<?php
/**
 * Menu Superior Separado - Layout Original com Botão Flutuante
 */
?>
<style>
    .badge-cart {
        background: #ef4444;
        color: white;
        font-size: 10px;
        font-weight: 700;
        padding: 2px 6px;
        border-radius: 10px;
        position: absolute;
        top: -5px;
        right: -5px;
        border: 2px solid #fff;
    }

    .cart-float {
        position: fixed;
        bottom: 25px;
        right: 25px;
        background: var(--p-color, #2563eb);
        color: #fff !important;
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        z-index: 99;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .cart-float:hover {
        transform: scale(1.1) translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.3);
    }

    .cart-float .badge-float {
        background: #fff;
        color: var(--p-color, #2563eb);
        font-size: 11px;
        font-weight: 900;
        min-width: 20px;
        height: 20px;
        padding: 0 6px;
        border-radius: 10px;
        position: absolute;
        top: 0;
        right: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
</style>

<header>
    <div class="max-w-7xl mx-auto px-4 h-16 flex justify-between items-center">
        <div class="flex items-center gap-3">
            <?php if(!empty($parceiro["logo"])): ?>
                <img src="<?= htmlspecialchars($parceiro["logo"]) ?>" class="h-8 w-auto">
            <?php endif; ?>
            <span class="font-bold text-lg text-slate-800"><?= htmlspecialchars($parceiro["nome"]) ?></span>
        </div>

        <div class="flex items-center gap-4 md:gap-6">
            <a href="favoritos.php?id=<?= $idParceiro ?>" class="text-slate-500 hover:text-primary transition-colors" title="Favoritos">
                <i class="ph ph-heart text-2xl"></i>
            </a>
            <a href="conta.php?id=<?= $idParceiro ?>" class="text-slate-500 hover:text-primary transition-colors flex items-center gap-2" title="Minha Conta">
                <i class="ph ph-user text-2xl"></i>
                <span id="clienteNome" class="hidden lg:inline text-xs font-bold text-slate-700"></span>
            </a>
            <a href="meus-pedidos.php?id=<?= $idParceiro ?>" class="text-slate-500 hover:text-primary transition-colors" title="Meus Downloads">
                <i class="ph ph-download-simple text-2xl"></i>
            </a>
            <a href="carrinho.php?id=<?= $idParceiro ?>" class="relative text-slate-500 hover:text-primary transition-colors" title="Carrinho">
                <i class="ph ph-shopping-cart text-2xl"></i>
                <span id="cartCount" class="badge-cart hidden">0</span>
            </a>
        </div>
    </div>
</header>

<!-- Botão Flutuante do Carrinho -->
<a href="carrinho.php?id=<?= $idParceiro ?>" id="cartFloat" class="cart-float hidden">
    <i class="ph ph-shopping-cart text-2xl"></i>
    <span id="cartCountFloat" class="badge-float">0</span>
</a>

<script>
    // Script para atualizar o nome do cliente e contador do carrinho no menu
    function atualizarMenu() {
        const idParceiro = '<?= $idParceiro ?>';
        const cliente = JSON.parse(localStorage.getItem('cliente_logado_' + idParceiro));
        const carrinho = JSON.parse(localStorage.getItem('carrinho_' + idParceiro)) || [];
        
        // Atualizar Nome do Cliente
        const nomeSpan = document.getElementById('clienteNome');
        if (cliente && nomeSpan) {
            nomeSpan.textContent = cliente.nome.split(' ')[0];
            nomeSpan.classList.remove('hidden');
        }

        // Atualizar Contador do Menu
        const cartCount = document.getElementById('cartCount');
        if (cartCount) {
            if (carrinho.length > 0) {
                cartCount.textContent = carrinho.length;
                cartCount.classList.remove('hidden');
            } else {
                cartCount.classList.add('hidden');
            }
        }

        // Atualizar Botão Flutuante
        const cartFloat = document.getElementById('cartFloat');
        const cartCountFloat = document.getElementById('cartCountFloat');
        if (cartFloat && cartCountFloat) {
            if (carrinho.length > 0) {
                cartCountFloat.textContent = carrinho.length;
                cartFloat.classList.remove('hidden');
            } else {
                cartFloat.classList.add('hidden');
            }
        }
    }
    document.addEventListener('DOMContentLoaded', atualizarMenu);
    window.addEventListener('storage', atualizarMenu);
    
    // Expor a função globalmente para ser chamada por outros scripts
    window.atualizarMenuGlobal = atualizarMenu;
</script>
