<?php
/**
 * Webhook PushinPay - Atualiza status do pedido PIX
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$base_path = __DIR__ . '/data/';
$pedidos_file = $base_path . 'pedidos.json';

// Recebe dados da PushinPay
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validação simples
if (!$data || !isset($data['id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Dados inválidos']);
    exit;
}

$pixId = $data['id']; // cashin_id / id do Pix
$pedidos = file_exists($pedidos_file) ? json_decode(file_get_contents($pedidos_file), true) : [];

$pedidoEncontrado = false;

foreach ($pedidos as &$p) {
    if (isset($p['pix']['id']) && strcasecmp($p['pix']['id'], $pixId) === 0) {
        // ✅ Pedido encontrado, atualiza status
        if ($p['status_pagamento'] !== 'pago') {
            $p['status_pagamento'] = 'pago';
            $p['status_pix'] = 'pago';
            $p['pix']['valor_pago'] = isset($data['value']) ? ((int)$data['value']/100) : null;
            $p['pix']['end_to_end_id'] = $data['end_to_end_id'] ?? null;
            $p['pix']['payer_name'] = $data['payer_name'] ?? null;
            $p['pix']['payer_national_registration'] = $data['payer_national_registration'] ?? null;
            $p['pix']['pago_em'] = date('c');
        }
        $pedidoEncontrado = true;
        break;
    }
}

// Salva alterações
if ($pedidoEncontrado) {
    file_put_contents($pedidos_file, json_encode($pedidos, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    http_response_code(200);
    echo json_encode(['success' => true, 'message' => 'Pedido atualizado']);
} else {
    http_response_code(404);
    echo json_encode(['success' => false, 'message' => 'Pedido não encontrado']);
}