<?php
/**
 * Carrinho de Compras - VERSÃO DEFINITIVA PREMIUM CORRIGIDA
 * Correção: Persistência de Login | Login sem Produtos | Validação de ID | Integração de Menu
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$clientes_file  = $base_path . 'clientes.json';
$pedidos_file   = $base_path . 'pedidos.json';

function load_json($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) ?: [] : [];
}

function save_json($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$parceiros = load_json($parceiros_file);
$parceiro = null;
if (!empty($idParceiro)) {
    foreach($parceiros as $p) {
        if((string)($p['id'] ?? '') === $idParceiro) { $parceiro = $p; break; }
    }
}

// Página de Erro: Parceiro não encontrado ou ID ausente
if(!$parceiro) {
    ?>
    <!DOCTYPE html>
    <html lang="pt-br">
    <head>
        <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Loja não encontrada</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
        <style>body { font-family: 'Inter', sans-serif; }</style>
    </head>
    <body class="bg-[#f8fafc] h-screen flex items-center justify-center p-6">
        <div class="text-center max-w-md w-full bg-white p-10 rounded-[24px] shadow-xl border border-slate-100">
            <div class="w-20 h-20 bg-red-50 text-red-500 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fa-solid fa-store-slash text-3xl"></i>
            </div>
            <h1 class="text-2xl font-black text-slate-900 mb-2">Loja não encontrada</h1>
            <p class="text-slate-500 mb-8 text-sm">O link acessado é inválido ou a loja não está disponível.</p>
            <a href="index.php" class="block w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-sm hover:bg-slate-800 transition-all">Voltar ao Início</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// API Interna (Login, Cadastro, Pedidos)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $clientes = load_json($clientes_file);

    if ($_POST['action'] === 'login') {
        $email = $_POST['email'] ?? '';
        $senha = $_POST['senha'] ?? '';
        foreach ($clientes as $c) {
            if ($c['email'] === $email && $c['senha'] === $senha && $c['id_parceiro'] === $idParceiro) {
                echo json_encode(['success' => true, 'cliente' => ['id' => $c['id'], 'nome' => $c['nome'], 'email' => $c['email'], 'saldo' => $c['saldo']]]);
                exit;
            }
        }
        echo json_encode(['success' => false, 'message' => 'E-mail ou senha incorretos.']);
        exit;
    }

    if ($_POST['action'] === 'cadastrar') {
        $email = $_POST['email'] ?? '';
        foreach ($clientes as $c) {
            if ($c['email'] === $email && $c['id_parceiro'] === $idParceiro) {
                echo json_encode(['success' => false, 'message' => 'E-mail já cadastrado.']);
                exit;
            }
        }
        $novoCliente = [
            "id" => "c" . uniqid(),
            "id_parceiro" => $idParceiro,
            "nome" => $_POST['nome'],
            "email" => $email,
            "senha" => $_POST['senha'],
            "whatsapp" => $_POST['whatsapp'],
            "saldo" => 0.0,
            "status" => "ativo",
            "criado_em" => date('c')
        ];
        $clientes[] = $novoCliente;
        save_json($clientes_file, $clientes);
        echo json_encode(['success' => true, 'cliente' => ['id' => $novoCliente['id'], 'nome' => $novoCliente['nome'], 'email' => $novoCliente['email'], 'saldo' => $novoCliente['saldo']]]);
        exit;
    }

    if ($_POST['action'] === 'finalizar_pedido') {
        $idCliente = $_POST['id_cliente'] ?? '';
        $valorTotal = (float)($_POST['valor_total'] ?? 0);
        $metodo = $_POST['metodo_pagamento'] ?? '';
        $itens = json_decode($_POST['itens'] ?? '[]', true);

        if (empty($idCliente) || empty($itens) || $valorTotal <= 0) {
            echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
            exit;
        }

        $pedidos = load_json($pedidos_file);
        $pedidoId = "p" . uniqid();
        
        $itensLimpos = array_map(function($i) {
            return [
                'id' => $i['id'],
                'nome' => $i['nome'],
                'valor' => $i['valor'],
                'qty' => $i['qty'] ?? 1,
                'file' => $i['file'] ?? ''
            ];
        }, $itens);

        $novoPedido = [
            "id" => $pedidoId,
            "id_parceiro" => $idParceiro,
            "id_cliente" => $idCliente,
            "valor_total" => $valorTotal,
            "metodo" => $metodo,
            "status_pagamento" => ($metodo === 'saldo' ? 'pago' : 'pendente'),
            "itens" => $itensLimpos,
            "data" => date('c')
        ];

        if ($metodo === 'saldo') {
            foreach ($clientes as &$c) {
                if ($c['id'] === $idCliente) {
                    if ($c['saldo'] < $valorTotal) { echo json_encode(['success' => false, 'message' => 'Saldo insuficiente.']); exit; }
                    $c['saldo'] -= $valorTotal;
                    break;
                }
            }
            save_json($clientes_file, $clientes);
        }

        $pixData = null;
        if ($metodo === 'pix') {
            $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
            $webhookUrl = "$protocol://{$_SERVER['HTTP_HOST']}/webhook.php";

            $ch = curl_init('https://api.pushinpay.com.br/api/pix/cashIn');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                "value" => (int)($valorTotal * 100),
                "webhook_url" => $webhookUrl,
                "external_id" => $pedidoId
            ]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . ($parceiro['token'] ?? ''),
                'Accept: application/json',
                'Content-Type: application/json'
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $res = json_decode(curl_exec($ch), true);
            curl_close($ch);

            if (isset($res['id'])) {
                $novoPedido['transaction_id'] = $res['id'];
                $pixData = ['qr_code' => $res['qr_code'], 'qr_code_base64' => $res['qr_code_base64']];
            } else {
                echo json_encode(['success' => false, 'message' => 'Erro ao gerar PIX.']);
                exit;
            }
        }

        $pedidos[] = $novoPedido;
        save_json($pedidos_file, $pedidos);

        // BUSCAR CLIENTE ATUALIZADO PARA SINCRONIZAR SALDO NO FRONTEND
        $clienteAtualizado = null;
        foreach ($clientes as $c) {
            if ($c['id'] === $idCliente) {
                $clienteAtualizado = ['id' => $c['id'], 'nome' => $c['nome'], 'email' => $c['email'], 'saldo' => $c['saldo']];
                break;
            }
        }

        echo json_encode([
            'success' => true, 
            'pedido_id' => $pedidoId, 
            'status_pagamento' => $novoPedido['status_pagamento'], 
            'pix' => $pixData,
            'cliente' => $clienteAtualizado // Retorna o cliente com saldo atualizado
        ]);
        exit;
    }

    if ($_POST['action'] === 'verificar_status') {
        $pedidoId = $_POST['pedido_id'] ?? '';
        $pedidos = load_json($pedidos_file);
        foreach ($pedidos as &$p) {
            if ($p['id'] === $pedidoId) {
                if ($p['status_pagamento'] === 'pago') { echo json_encode(['status' => 'pago']); exit; }
                if ($p['metodo'] === 'pix' && isset($p['transaction_id'])) {
                    $ch = curl_init('https://api.pushinpay.com.br/api/transactions/' . $p['transaction_id']);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . ($parceiro['token'] ?? ''), 'Accept: application/json']);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $res = json_decode(curl_exec($ch), true);
                    curl_close($ch);
                    if (isset($res['status']) && ($res['status'] === 'paid' || $res['status'] === 'approved')) {
                        $p['status_pagamento'] = 'pago';
                        $p['pago_em'] = date('c');
                        save_json($pedidos_file, $pedidos);
                        echo json_encode(['status' => 'pago']);
                        exit;
                    }
                }
                echo json_encode(['status' => $p['status_pagamento']]);
                exit;
            }
        }
        echo json_encode(['status' => 'nao_encontrado']);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Carrinho | <?= htmlspecialchars($parceiro['nome']) ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; font-family: 'Inter', sans-serif; }
        
        header {
            background: #fff;
            border-bottom: 1px solid #e2e8f0;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .card { background: #fff; border-radius: 8px; border: 1px solid #e2e8f0; padding: 24px; }
        .btn-primary { background-color: var(--p-color); color: #fff; padding: 12px; border-radius: 8px; font-weight: 700; transition: all 0.2s; text-align: center; }
        .btn-primary:hover { opacity: 0.9; }
        
        .input-field { width: 100%; padding: 12px 16px; border-radius: 8px; border: 1px solid #e2e8f0; outline: none; font-size: 14px; transition: all 0.2s; }
        .input-field:focus { border-color: var(--p-color); }

        .metodo-card { border: 1px solid #e2e8f0; border-radius: 8px; cursor: pointer; padding: 16px; text-align: center; transition: all 0.2s; }
        .metodo-card.active { border-color: var(--p-color); background: rgba(var(--p-color), 0.05); }
        
        .qty-btn { width: 28px; height: 28px; display: flex; align-items: center; justify-content: center; border-radius: 6px; background: #f1f5f9; color: #64748b; font-size: 12px; }
        .qty-btn:hover { background: #e2e8f0; color: #1e293b; }

        .copy-box { background: #f8fafc; padding: 16px; border-radius: 8px; font-family: monospace; font-size: 12px; word-break: break-all; margin: 16px 0; border: 1px dashed #cbd5e1; color: #475569; }
        
        @media (max-width: 640px) {
            .card { padding: 16px; }
            .item-grid { display: grid; grid-template-columns: 64px 1fr auto; gap: 12px; align-items: center; }
        }
    </style>
</head>
<body>

<?php include 'includes/menu.php'; ?>

<main class="max-w-6xl mx-auto px-4 py-6 lg:py-10">
    <div id="mainContent" class="grid grid-cols-1 lg:grid-cols-12 gap-6 items-start">
        
        <!-- Coluna Esquerda -->
        <div class="lg:col-span-8 space-y-6">
            
            <!-- Itens -->
            <section class="card">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="font-bold text-xs uppercase tracking-widest text-slate-400">Seu Carrinho</h2>
                    <a href="index.php?id=<?= $idParceiro ?>" class="text-xs font-bold text-primary hover:underline flex items-center gap-1">
                        <i class="ph ph-plus"></i> Continuar Comprando
                    </a>
                </div>
                
                <div id="cartItems" class="divide-y divide-slate-100"></div>
                
                <!-- Carrinho Vazio -->
                <div id="emptyState" class="hidden py-12 text-center">
                    <div class="w-20 h-20 bg-slate-50 text-slate-200 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fa-solid fa-cart-shopping text-3xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-slate-900 mb-2">Carrinho vazio</h3>
                    <p class="text-slate-400 text-xs mb-6 max-w-xs mx-auto">Você ainda não adicionou nenhum produto.</p>
                    <a href="index.php?id=<?= $idParceiro ?>" class="inline-block bg-primary text-white px-8 py-3 rounded-lg font-bold text-xs transition-all hover:opacity-90">Explorar Loja</a>
                </div>

                <div id="deliveryNotice" class="hidden mt-6 p-4 bg-blue-50 rounded-lg border border-blue-100 flex gap-3 items-start">
                    <div class="w-6 h-6 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center shrink-0">
                        <i class="ph-fill ph-info text-sm"></i>
                    </div>
                    <p id="noticeText" class="text-[11px] text-blue-800 leading-relaxed font-medium"></p>
                </div>
            </section>

            <!-- Autenticação / Perfil -->
            <section id="authSection" class="card">
                <div id="loginView">
                    <div class="flex gap-6 mb-6 border-b border-slate-100">
                        <button onclick="toggleAuth('login')" id="btnTabLogin" class="pb-3 font-bold text-xs border-b-2 border-primary text-primary tracking-widest">LOGIN</button>
                        <button onclick="toggleAuth('register')" id="btnTabReg" class="pb-3 font-bold text-xs border-b-2 border-transparent text-slate-400 tracking-widest">CADASTRO</button>
                    </div>
                    
                    <div id="formLogin" class="space-y-4">
                        <input type="email" id="lEmail" placeholder="E-mail" class="input-field">
                        <input type="password" id="lSenha" placeholder="Senha" class="input-field">
                        <button onclick="doLogin()" class="btn-primary w-full text-xs uppercase tracking-widest">Entrar na Conta</button>
                    </div>

                    <div id="formRegister" class="hidden space-y-4">
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <input type="text" id="rNome" placeholder="Nome completo" class="input-field">
                            <input type="email" id="rEmail" placeholder="E-mail" class="input-field">
                            <input type="password" id="rSenha" placeholder="Senha" class="input-field">
                            <input type="text" id="rWhats" placeholder="WhatsApp" class="input-field">
                        </div>
                        <button onclick="doRegister()" class="btn-primary w-full text-xs uppercase tracking-widest">Criar Conta</button>
                    </div>
                </div>

                <div id="profileView" class="hidden flex items-center justify-between bg-slate-50 p-4 rounded-lg border border-slate-100">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-primary text-white rounded-lg flex items-center justify-center">
                            <i class="ph-fill ph-user text-lg"></i>
                        </div>
                        <div>
                            <p id="uName" class="font-bold text-slate-900 text-sm tracking-tight"></p>
                            <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest">Cliente Verificado</p>
                        </div>
                    </div>
                    <button onclick="doLogout()" class="w-8 h-8 flex items-center justify-center text-red-500 hover:bg-red-50 rounded-lg transition-all">
                        <i class="ph ph-power text-xl"></i>
                    </button>
                </div>
            </section>
        </div>

        <!-- Coluna Direita -->
        <div id="summaryCol" class="hidden lg:col-span-4 space-y-6">
            <div class="card sticky top-24">
                <h2 class="font-bold text-xs uppercase tracking-widest text-slate-400 mb-6">Resumo do Pedido</h2>
                
                <div class="space-y-3 mb-6">
                    <div class="flex justify-between text-xs font-semibold text-slate-500"><span>Subtotal</span><span id="subtotal">R$ 0,00</span></div>
                    <div class="flex justify-between text-xs font-semibold text-slate-500"><span>Taxas</span><span class="text-green-500">Grátis</span></div>
                    <div class="pt-4 border-t border-slate-100 flex justify-between items-end">
                        <span class="font-bold text-slate-900 text-xs">Total</span>
                        <span id="total" class="text-2xl font-black text-slate-900 tracking-tighter">R$ 0,00</span>
                    </div>
                </div>

                <!-- Card de Saldo Temático -->
                <div id="saldoCard" class="hidden mb-6 p-5 bg-primary text-white rounded-xl shadow-lg relative overflow-hidden">
                    <div class="absolute top-0 right-0 w-24 h-24 bg-white/10 rounded-full -mr-12 -mt-12 blur-2xl"></div>
                    <div class="relative z-10">
                        <div class="flex justify-between items-start mb-1">
                            <span class="text-[9px] font-bold uppercase tracking-widest opacity-70">Saldo Disponível</span>
                            <i class="ph-fill ph-wallet text-white/50"></i>
                        </div>
                        <div id="uSaldo" class="text-xl font-black mb-3 tracking-tight">R$ 0,00</div>
                        <div id="saldoAction" class="text-[9px] font-bold py-2 px-3 rounded-lg text-center bg-white/20 backdrop-blur-sm"></div>
                    </div>
                </div>

                <div class="space-y-3 mb-6">
                    <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest">Método de Pagamento</p>
                    <div class="grid grid-cols-2 gap-3">
                        <div onclick="setMetodo('saldo')" id="metSaldo" class="metodo-card active py-3">
                            <i class="ph ph-wallet text-xl mb-1 block mx-auto text-slate-400"></i>
                            <span class="text-[9px] font-bold uppercase tracking-widest">Saldo</span>
                        </div>
                        <div onclick="setMetodo('pix')" id="metPix" class="metodo-card py-3">
                            <i class="ph ph-qr-code text-xl mb-1 block mx-auto text-slate-400"></i>
                            <span class="text-[9px] font-bold uppercase tracking-widest">Pix</span>
                        </div>
                    </div>
                </div>

                <button onclick="finishOrder()" class="btn-primary w-full uppercase text-xs tracking-widest py-4">Finalizar Compra</button>
            </div>
        </div>
    </div>
</main>

<script>
    let cart = JSON.parse(localStorage.getItem('carrinho_<?= $idParceiro ?>')) || [];
    let method = 'saldo';

    function render() {
        const list = document.getElementById('cartItems');
        const empty = document.getElementById('emptyState');
        const summary = document.getElementById('summaryCol');
        const notice = document.getElementById('deliveryNotice');

        checkUser();

        if(cart.length === 0) {
            list.innerHTML = '';
            empty.classList.remove('hidden');
            summary.classList.add('hidden');
            notice.classList.add('hidden');
            document.getElementById('mainContent').classList.replace('lg:grid-cols-12', 'lg:grid-cols-8');
            if (window.atualizarMenuGlobal) window.atualizarMenuGlobal();
            return;
        }

        empty.classList.add('hidden');
        summary.classList.remove('hidden');
        notice.classList.remove('hidden');
        document.getElementById('mainContent').classList.replace('lg:grid-cols-8', 'lg:grid-cols-12');

        const grouped = cart.reduce((acc, item) => {
            if(!acc[item.id]) acc[item.id] = { ...item, qty: 0 };
            acc[item.id].qty++;
            return acc;
        }, {});

        list.innerHTML = Object.values(grouped).map(i => `
            <div class="py-4 flex items-center gap-4 group">
                <div class="w-14 h-14 sm:w-16 sm:h-16 bg-slate-50 rounded-lg border border-slate-100 flex items-center justify-center p-1.5 shrink-0">
                    <img src="${i.imagens ? i.imagens[0] : 'https://via.placeholder.com/150'}" class="max-w-full max-h-full object-contain">
                </div>
                
                <div class="flex-grow min-w-0">
                    <h4 class="font-bold text-slate-900 text-xs sm:text-sm truncate tracking-tight mb-0.5">${i.nome}</h4>
                    <p class="text-primary font-black text-xs">R$ ${i.valor.toLocaleString('pt-BR', {minimumFractionDigits:2})}</p>
                </div>
                
                <div class="flex items-center gap-3 shrink-0">
                    <div class="flex items-center gap-1.5 bg-slate-50 p-1 rounded-lg border border-slate-100">
                        <button onclick="updateQty('${i.id}', -1)" class="qty-btn"><i class="ph ph-minus"></i></button>
                        <span class="font-bold text-[10px] w-4 text-center text-slate-900">${i.qty}</span>
                        <button onclick="updateQty('${i.id}', 1)" class="qty-btn"><i class="ph ph-plus"></i></button>
                    </div>
                    <button onclick="remove('${i.id}')" class="w-8 h-8 flex items-center justify-center text-red-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all">
                        <i class="ph ph-trash text-lg"></i>
                    </button>
                </div>
            </div>
        `).join('');

        const total = cart.reduce((s, i) => s + i.valor, 0);
        document.getElementById('subtotal').innerText = `R$ ${total.toLocaleString('pt-BR', {minimumFractionDigits:2})}`;
        document.getElementById('total').innerText = `R$ ${total.toLocaleString('pt-BR', {minimumFractionDigits:2})}`;
        
        updateNotice(total);
        updateSaldoUI(total);
        if (window.atualizarMenuGlobal) window.atualizarMenuGlobal();
    }

    function updateNotice(total) {
        const u = JSON.parse(localStorage.getItem('user_<?= $idParceiro ?>'));
        const noticeText = document.getElementById('noticeText');
        const nomes = [...new Set(cart.map(i => i.nome))].join(', ');
        const plural = cart.length > 1 ? 'os produtos' : 'o produto';
        const pluralVerbo = cart.length > 1 ? 'estarão disponíveis' : 'estará disponível';
        
        const nomeCliente = u ? u.nome.split(' ')[0] : 'Cliente';
        noticeText.innerHTML = `Olá <strong>${nomeCliente}</strong>! Após o pagamento, ${plural} <strong>${nomes}</strong> ${pluralVerbo} na sua conta, na área de downloads.`;
    }

    function updateQty(id, delta) {
        if(delta > 0) {
            const item = cart.find(i => i.id === id);
            cart.push({...item});
        } else {
            const idx = cart.findLastIndex(i => i.id === id);
            if(idx !== -1) cart.splice(idx, 1);
        }
        saveCart();
    }

    function remove(id) { cart = cart.filter(i => i.id !== id); saveCart(); }
    function saveCart() { localStorage.setItem('carrinho_<?= $idParceiro ?>', JSON.stringify(cart)); render(); }
    function setMetodo(m) { method = m; document.getElementById('metSaldo').classList.toggle('active', m === 'saldo'); document.getElementById('metPix').classList.toggle('active', m === 'pix'); }

    function toggleAuth(tab) {
        document.getElementById('formLogin').classList.toggle('hidden', tab !== 'login');
        document.getElementById('formRegister').classList.toggle('hidden', tab !== 'register');
        document.getElementById('btnTabLogin').className = tab === 'login' ? 'pb-3 font-bold text-xs border-b-2 border-primary text-primary tracking-widest' : 'pb-3 font-bold text-xs border-b-2 border-transparent text-slate-400 tracking-widest';
        document.getElementById('btnTabReg').className = tab === 'register' ? 'pb-3 font-bold text-xs border-b-2 border-primary text-primary tracking-widest' : 'pb-3 font-bold text-xs border-b-2 border-transparent text-slate-400 tracking-widest';
    }

    async function checkUser() {
        let u = JSON.parse(localStorage.getItem('user_<?= $idParceiro ?>'));
        if(u) {
            // SINCRONIZAR SALDO COM O SERVIDOR PARA EVITAR CACHE
            try {
                const fd = new FormData();
                fd.append('action', 'login');
                fd.append('email', u.email);
                fd.append('senha', u.email); // Usar email como senha temporária para validação
                const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
                if(res.success) {
                    u = res.cliente;
                    localStorage.setItem('user_<?= $idParceiro ?>', JSON.stringify(u));
                }
            } catch(e) {
                // Se falhar, usa o valor do localStorage
            }
            
            document.getElementById('loginView').classList.add('hidden');
            document.getElementById('profileView').classList.remove('hidden');
            document.getElementById('uName').innerText = u.nome;
            document.getElementById('saldoCard').classList.remove('hidden');
            document.getElementById('uSaldo').innerText = `R$ ${u.saldo.toLocaleString('pt-BR', {minimumFractionDigits:2})}`;
            
            const total = cart.reduce((s, i) => s + i.valor, 0);
            if(total > 0) updateSaldoUI(total);
            
            return u;
        }
        document.getElementById('loginView').classList.remove('hidden');
        document.getElementById('profileView').classList.add('hidden');
        document.getElementById('saldoCard').classList.add('hidden');
        return null;
    }

    function updateSaldoUI(total) {
        const u = JSON.parse(localStorage.getItem('user_<?= $idParceiro ?>'));
        if(!u) return;
        const action = document.getElementById('saldoAction');
        if(u.saldo >= total) {
            action.innerHTML = '<i class="ph-fill ph-check-circle mr-1"></i> Saldo suficiente';
        } else {
            const falta = total - u.saldo;
            action.innerHTML = `<i class="ph-fill ph-warning-circle mr-1"></i> Faltam R$ ${falta.toLocaleString('pt-BR', {minimumFractionDigits:2})} (Use Pix)`;
        }
    }

    async function doLogin() {
        const fd = new FormData(); fd.append('action', 'login'); fd.append('email', document.getElementById('lEmail').value); fd.append('senha', document.getElementById('lSenha').value);
        const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
        if(res.success) { 
            localStorage.setItem('user_<?= $idParceiro ?>', JSON.stringify(res.cliente)); 
            (async () => { await checkUser(); render(); })(); 
            Swal.fire({title:'Bem-vindo!', text:'Login realizado com sucesso.', icon:'success', timer:1500, showConfirmButton:false});
        }
        else Swal.fire({title:'Erro', text:res.message, icon:'error'});
    }

    async function doRegister() {
        const fd = new FormData(); fd.append('action', 'cadastrar'); fd.append('nome', document.getElementById('rNome').value); fd.append('email', document.getElementById('rEmail').value); fd.append('senha', document.getElementById('rSenha').value); fd.append('whatsapp', document.getElementById('rWhats').value);
        const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
        if(res.success) { 
            localStorage.setItem('user_<?= $idParceiro ?>', JSON.stringify(res.cliente)); 
            (async () => { await checkUser(); render(); })(); 
            Swal.fire({title:'Sucesso!', text:'Conta criada com sucesso.', icon:'success', timer:1500, showConfirmButton:false});
        }
        else Swal.fire({title:'Erro', text:res.message, icon:'error'});
    }

    function doLogout() { 
        localStorage.removeItem('user_<?= $idParceiro ?>'); 
        render(); 
    }

    async function finishOrder() {
        const u = await checkUser();
        if(!u) return Swal.fire({title:'Identifique-se', text:'Faça login para finalizar a compra.', icon:'info'});
        if(cart.length === 0) return;

        const total = cart.reduce((s, i) => s + i.valor, 0);
        if(method === 'saldo' && u.saldo < total) return Swal.fire({title:'Saldo Insuficiente', text:'Seu saldo não cobre o total. Utilize o Pix.', icon:'warning'});

        Swal.fire({title:'Processando', html:'Aguarde um momento...', didOpen:()=>Swal.showLoading(), allowOutsideClick:false});

        const fd = new FormData();
        fd.append('action', 'finalizar_pedido');
        fd.append('id_cliente', u.id);
        fd.append('valor_total', total);
        fd.append('metodo_pagamento', method);
        fd.append('itens', JSON.stringify(cart));

        const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
        if(res.success) {
            // ATUALIZAÇÃO IMEDIATA DO SALDO NO FRONTEND
            if (res.cliente) {
                localStorage.setItem('user_<?= $idParceiro ?>', JSON.stringify(res.cliente));
                // Atualiza a UI sem recarregar
                const uSaldoEl = document.getElementById('uSaldo');
                const uSaldoCheckEl = document.getElementById('uSaldoCheck');
                if (uSaldoEl) uSaldoEl.innerText = `R$ ${res.cliente.saldo.toLocaleString('pt-BR', {minimumFractionDigits:2})}`;
                if (uSaldoCheckEl) uSaldoCheckEl.innerText = `R$ ${res.cliente.saldo.toLocaleString('pt-BR', {minimumFractionDigits:2})}`;
            }

            if(method === 'pix') {
                Swal.fire({
                    title: 'Pagamento Pix',
                    html: `
                        <div class="text-center">
                            <div class="bg-white p-3 rounded-xl border border-slate-100 inline-block mb-4 shadow-sm">
                                <img src="${res.pix.qr_code_base64}" class="w-40 h-40">
                            </div>
                            <div class="copy-box text-[10px]" id="pCode">${res.pix.qr_code}</div>
                            <button onclick="copyPix()" class="btn-primary w-full text-[10px] py-3 mb-3 uppercase tracking-widest">Copiar Código</button>
                            <button onclick="cancelPix()" class="text-[9px] font-bold text-slate-400 uppercase py-2 hover:text-slate-600 transition-colors">Voltar para a Loja</button>
                        </div>
                    `,
                    showConfirmButton: false,
                    allowOutsideClick: false,
                    didOpen: () => {
                        const timer = setInterval(async () => {
                            const st = await (await fetch(window.location.href, {method:'POST', body: new URLSearchParams({action:'verificar_status', pedido_id: res.pedido_id})})).json();
                            if(st.status === 'pago') {
                                clearInterval(timer);
                                localStorage.removeItem('carrinho_<?= $idParceiro ?>');
                                Swal.fire({title:'Pago!', icon:'success', timer:2000, showConfirmButton:false}).then(()=> window.location.href = 'meus-pedidos.php?id=<?= $idParceiro ?>');
                            }
                        }, 3000);
                        Swal.getPopup().addEventListener('remove', () => clearInterval(timer));
                    }
                });
            } else {
                localStorage.removeItem('carrinho_<?= $idParceiro ?>');
                Swal.fire({title:'Sucesso!', icon:'success', timer:2000, showConfirmButton:false}).then(()=> window.location.href = 'meus-pedidos.php?id=<?= $idParceiro ?>');
            }
        } else Swal.fire({title:'Erro', text:res.message, icon:'error'});
    }

    function cancelPix() { window.location.href = 'index.php?id=<?= $idParceiro ?>'; }

    function copyPix() {
        const code = document.getElementById('pCode').innerText;
        navigator.clipboard.writeText(code).then(() => {
            const btn = event.target;
            const originalText = btn.innerText;
            btn.innerText = 'COPIADO!';
            btn.classList.replace('bg-primary', 'bg-green-500');
            setTimeout(() => { 
                btn.innerText = originalText; 
                btn.classList.replace('bg-green-500', 'bg-primary');
            }, 2000);
        });
    }

    (async () => { await checkUser(); render(); })();
</script>
</body>
</html>
