<?php
/**
 * Carrinho de Compras - Produção (Versão Final Corrigida)
 * Integração PushinPay + Consulta Direta + JSON Limpo
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$clientes_file  = $base_path . 'clientes.json';
$pedidos_file   = $base_path . 'pedidos.json';

function load_json($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) ?: [] : [];
}

function save_json($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$parceiros = load_json($parceiros_file);
$parceiro = null;
foreach($parceiros as $p) {
    if((string)($p['id'] ?? '') === $idParceiro) { $parceiro = $p; break; }
}
if(!$parceiro) $parceiro = ['nome' => 'Loja', 'cor_primaria' => '#2563eb', 'token' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $clientes = load_json($clientes_file);

    if ($_POST['action'] === 'login') {
        $email = $_POST['email'] ?? '';
        $senha = $_POST['senha'] ?? '';
        foreach ($clientes as $c) {
            if ($c['email'] === $email && $c['senha'] === $senha && $c['id_parceiro'] === $idParceiro) {
                echo json_encode(['success' => true, 'cliente' => ['id' => $c['id'], 'nome' => $c['nome'], 'email' => $c['email'], 'saldo' => $c['saldo']]]);
                exit;
            }
        }
        echo json_encode(['success' => false, 'message' => 'Credenciais inválidas.']);
        exit;
    }

    if ($_POST['action'] === 'finalizar_pedido') {
        $idCliente = $_POST['id_cliente'] ?? '';
        $valorTotal = (float)($_POST['valor_total'] ?? 0);
        $metodo = $_POST['metodo_pagamento'] ?? '';
        $itens = json_decode($_POST['itens'] ?? '[]', true);

        if (empty($idCliente) || empty($itens) || $valorTotal <= 0) {
            echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
            exit;
        }

        $pedidos = load_json($pedidos_file);
        $pedidoId = "p" . uniqid();
        
        $itensLimpos = array_map(function($i) {
            return [
                'id' => $i['id'],
                'nome' => $i['nome'],
                'valor' => $i['valor'],
                'file' => $i['file'] ?? ''
            ];
        }, $itens);

        $novoPedido = [
            "id" => $pedidoId,
            "id_parceiro" => $idParceiro,
            "id_cliente" => $idCliente,
            "valor_total" => $valorTotal,
            "metodo" => $metodo,
            "status_pagamento" => ($metodo === 'saldo' ? 'pago' : 'pendente'),
            "itens" => $itensLimpos,
            "data" => date('c')
        ];

        if ($metodo === 'saldo') {
            foreach ($clientes as &$c) {
                if ($c['id'] === $idCliente) {
                    if ($c['saldo'] < $valorTotal) { echo json_encode(['success' => false, 'message' => 'Saldo insuficiente.']); exit; }
                    $c['saldo'] -= $valorTotal;
                    break;
                }
            }
            save_json($clientes_file, $clientes);
        }

        $pixData = null;
        if ($metodo === 'pix') {
            $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
            $webhookUrl = "$protocol://{$_SERVER['HTTP_HOST']}/webhook.php";

            $ch = curl_init('https://api.pushinpay.com.br/api/pix/cashIn');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                "value" => (int)($valorTotal * 100),
                "webhook_url" => $webhookUrl,
                "external_id" => $pedidoId
            ]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . ($parceiro['token'] ?? ''),
                'Accept: application/json',
                'Content-Type: application/json'
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $res = json_decode(curl_exec($ch), true);
            curl_close($ch);

            if (isset($res['id'])) {
                $novoPedido['transaction_id'] = $res['id'];
                $pixData = ['qr_code' => $res['qr_code'], 'qr_code_base64' => $res['qr_code_base64']];
            } else {
                echo json_encode(['success' => false, 'message' => 'Erro ao gerar PIX.']);
                exit;
            }
        }

        $pedidos[] = $novoPedido;
        save_json($pedidos_file, $pedidos);

        echo json_encode(['success' => true, 'pedido_id' => $pedidoId, 'status_pagamento' => $novoPedido['status_pagamento'], 'pix' => $pixData]);
        exit;
    }

    if ($_POST['action'] === 'verificar_status') {
        $pedidoId = $_POST['pedido_id'] ?? '';
        $pedidos = load_json($pedidos_file);
        $pedido = null;
        foreach ($pedidos as &$p) {
            if ($p['id'] === $pedidoId) { $pedido = &$p; break; }
        }

        if (!$pedido) { echo json_encode(['status' => 'nao_encontrado']); exit; }

        // Se já estiver pago no nosso JSON, retorna logo
        if ($pedido['status_pagamento'] === 'pago') { echo json_encode(['status' => 'pago']); exit; }

        // Se for Pix e ainda estiver pendente, consulta a API da PushinPay diretamente
        if ($pedido['metodo'] === 'pix' && isset($pedido['transaction_id'])) {
            $ch = curl_init('https://api.pushinpay.com.br/api/transactions/' . $pedido['transaction_id']);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . ($parceiro['token'] ?? ''),
                'Accept: application/json'
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $res = json_decode(curl_exec($ch), true);
            curl_close($ch);

            if (isset($res['status']) && ($res['status'] === 'paid' || $res['status'] === 'approved')) {
                $pedido['status_pagamento'] = 'pago';
                $pedido['pago_em'] = date('c');
                save_json($pedidos_file, $pedidos);
                echo json_encode(['status' => 'pago']);
                exit;
            }
        }

        echo json_encode(['status' => $pedido['status_pagamento']]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Checkout | <?= htmlspecialchars($parceiro['nome']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background: #f8fafc; font-family: sans-serif; }
        .btn-primary { background: var(--p-color); color: white; font-weight: bold; }
        .metodo-card { border: 2px solid #e2e8f0; border-radius: 12px; cursor: pointer; }
        .metodo-card.active { border-color: var(--p-color); background: #eff6ff; }
        .pix-box { text-align: center; padding: 10px; }
        .copy-box { background: #f1f5f9; padding: 10px; border-radius: 8px; font-size: 10px; word-break: break-all; margin: 10px 0; border: 1px dashed #cbd5e1; }
    </style>
</head>
<body>

<header class="bg-white border-b p-4 flex justify-between items-center">
    <a href="index.php?id=<?= $idParceiro ?>" class="text-sm font-bold text-slate-600"><i class="ph ph-arrow-left"></i> Voltar</a>
    <h1 class="font-bold text-lg">Meu Carrinho</h1>
    <div class="w-10"></div>
</header>

<main class="max-w-4xl mx-auto p-6 grid grid-cols-1 md:grid-cols-2 gap-8">
    <div class="space-y-6">
        <div class="bg-white p-6 rounded-xl shadow-sm border">
            <h2 class="font-bold mb-4 flex items-center gap-2"><i class="ph ph-shopping-cart"></i> Itens</h2>
            <div id="cartList" class="divide-y"></div>
        </div>
        <div id="authSection" class="bg-white p-6 rounded-xl shadow-sm border">
            <div id="loginForm" class="space-y-4">
                <input type="email" id="email" placeholder="E-mail" class="w-full p-3 border rounded-lg outline-none focus:border-blue-500">
                <input type="password" id="senha" placeholder="Senha" class="w-full p-3 border rounded-lg outline-none focus:border-blue-500">
                <button onclick="login()" class="btn-primary w-full py-3 rounded-lg">Acessar Conta</button>
            </div>
            <div id="userInfo" class="hidden flex justify-between items-center">
                <div><p class="text-xs text-slate-400 font-bold uppercase">Logado como</p><p id="userName" class="font-bold"></p></div>
                <button onclick="logout()" class="text-red-500 font-bold text-xs">SAIR</button>
            </div>
        </div>
    </div>

    <div class="space-y-6">
        <div class="bg-white p-6 rounded-xl shadow-sm border sticky top-6">
            <h2 class="font-bold mb-4">Resumo</h2>
            <div class="flex justify-between mb-4"><span class="text-slate-500">Total</span><span id="totalPrice" class="text-2xl font-black">R$ 0,00</span></div>
            <div id="saldoBox" class="hidden bg-blue-50 p-4 rounded-lg border border-blue-100 mb-4">
                <p class="text-[10px] font-bold text-blue-600 uppercase">Seu Saldo</p>
                <p id="userSaldo" class="text-xl font-black text-blue-700">R$ 0,00</p>
            </div>
            <div class="grid grid-cols-2 gap-3 mb-6">
                <div onclick="setMetodo('saldo')" id="mSaldo" class="metodo-card p-4 text-center active"><i class="ph ph-wallet text-xl"></i><p class="text-[10px] font-bold uppercase mt-1">Saldo</p></div>
                <div onclick="setMetodo('pix')" id="mPix" class="metodo-card p-4 text-center"><i class="ph ph-qr-code text-xl"></i><p class="text-[10px] font-bold uppercase mt-1">Pix</p></div>
            </div>
            <button onclick="finalizar()" class="btn-primary w-full py-4 rounded-xl shadow-lg uppercase text-sm tracking-widest">Finalizar Pedido</button>
        </div>
    </div>
</main>

<script>
    let carrinho = JSON.parse(localStorage.getItem('carrinho_<?= $idParceiro ?>')) || [];
    let metodo = 'saldo';

    function render() {
        const list = document.getElementById('cartList');
        if(!carrinho.length) { list.innerHTML = '<p class="text-center py-4 text-slate-400">Vazio</p>'; return; }
        list.innerHTML = carrinho.map(i => `<div class="py-3 flex justify-between items-center"><div><p class="font-bold text-sm">${i.nome}</p><p class="text-blue-600 font-bold text-xs">R$ ${i.valor.toFixed(2)}</p></div><button onclick="remove('${i.id}')" class="text-slate-300 hover:text-red-500"><i class="ph ph-trash text-lg"></i></button></div>`).join('');
        document.getElementById('totalPrice').innerText = `R$ ${carrinho.reduce((s, i) => s + i.valor, 0).toFixed(2)}`;
        checkLogin();
    }

    function remove(id) { carrinho = carrinho.filter(i => i.id !== id); localStorage.setItem('carrinho_<?= $idParceiro ?>', JSON.stringify(carrinho)); render(); }
    function setMetodo(m) { metodo = m; document.getElementById('mSaldo').classList.toggle('active', m === 'saldo'); document.getElementById('mPix').classList.toggle('active', m === 'pix'); }

    function checkLogin() {
        const u = JSON.parse(localStorage.getItem('user_<?= $idParceiro ?>'));
        if(u) {
            document.getElementById('loginForm').classList.add('hidden');
            document.getElementById('userInfo').classList.remove('hidden');
            document.getElementById('userName').innerText = u.nome;
            document.getElementById('saldoBox').classList.remove('hidden');
            document.getElementById('userSaldo').innerText = `R$ ${u.saldo.toFixed(2)}`;
            return u;
        }
        document.getElementById('loginForm').classList.remove('hidden');
        document.getElementById('userInfo').classList.add('hidden');
        document.getElementById('saldoBox').classList.add('hidden');
        return null;
    }

    async function login() {
        const fd = new FormData(); fd.append('action', 'login'); fd.append('email', document.getElementById('email').value); fd.append('senha', document.getElementById('senha').value);
        const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
        if(res.success) { localStorage.setItem('user_<?= $idParceiro ?>', JSON.stringify(res.cliente)); render(); }
        else Swal.fire('Erro', res.message, 'error');
    }

    function logout() { localStorage.removeItem('user_<?= $idParceiro ?>'); render(); }

    async function finalizar() {
        const u = checkLogin(); if(!u) return Swal.fire('Aviso', 'Faça login primeiro.', 'info');
        if(!carrinho.length) return Swal.fire('Aviso', 'Carrinho vazio.', 'warning');
        
        Swal.fire({title:'Processando...', didOpen:()=>Swal.showLoading(), allowOutsideClick:false});
        
        const fd = new FormData();
        fd.append('action', 'finalizar_pedido');
        fd.append('id_cliente', u.id);
        fd.append('valor_total', carrinho.reduce((s,i)=>s+i.valor, 0));
        fd.append('metodo_pagamento', metodo);
        fd.append('itens', JSON.stringify(carrinho));

        const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
        if(res.success) {
            if(metodo === 'pix') {
                Swal.fire({
                    title: 'Pagamento Pix',
                    html: `<div class="pix-box"><img src="${res.pix.qr_code_base64}" class="mx-auto w-48 mb-4"><div class="copy-box" id="pCode">${res.pix.qr_code}</div><button onclick="copyPix()" class="btn-primary w-full py-3 rounded-lg text-sm">COPIAR CÓDIGO</button><div class="mt-6 flex items-center justify-center gap-2 text-blue-600 animate-pulse"><i class="ph ph-circle-notch animate-spin"></i><span class="text-[10px] font-bold uppercase">Aguardando Pagamento...</span></div></div>`,
                    showConfirmButton: false,
                    allowOutsideClick: false,
                    didOpen: () => {
                        const timer = setInterval(async () => {
                            const st = await (await fetch(window.location.href, {method:'POST', body: new URLSearchParams({action:'verificar_status', pedido_id: res.pedido_id})})).json();
                            if(st.status === 'pago') {
                                clearInterval(timer);
                                localStorage.removeItem('carrinho_<?= $idParceiro ?>');
                                Swal.fire({title:'Sucesso!', text:'Pagamento confirmado!', icon:'success', timer:2000, showConfirmButton:false}).then(()=> window.location.href = 'meus-pedidos.php?id=<?= $idParceiro ?>');
                            }
                        }, 3000);
                    }
                });
            } else {
                localStorage.removeItem('carrinho_<?= $idParceiro ?>');
                Swal.fire('Sucesso!', 'Pedido finalizado!', 'success').then(()=> window.location.href = 'meus-pedidos.php?id=<?= $idParceiro ?>');
            }
        } else Swal.fire('Erro', res.message, 'error');
    }

    function copyPix() {
        const code = document.getElementById('pCode').innerText;
        navigator.clipboard.writeText(code).then(() => {
            Swal.showValidationMessage('Código Copiado!');
            setTimeout(() => { if(Swal.getValidationMessage() === 'Código Copiado!') Swal.resetValidationMessage(); }, 2000);
        });
    }

    render();
</script>
</body>
</html>
