<?php
session_start();

// Redireciona se não estiver logado
if(!isset($_SESSION['usuario'])){
    header("Location: admin_login.php");
    exit;
}

$usuario = $_SESSION['usuario'];
$parceiro_logado = $usuario['id'];

// Caminhos dos JSON
$produtosJson = __DIR__ . '/data/produtos.json';
if(!file_exists($produtosJson)){
    file_put_contents($produtosJson, '[]');
}

// Pasta de uploads
$uploadDir = __DIR__ . '/uploads/';
if(!is_dir($uploadDir)) mkdir($uploadDir, 0755);

// Processa envio do formulário
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $nome = trim($_POST['nome'] ?? '');
    $descricao = trim($_POST['descricao'] ?? '');
    $valor = floatval($_POST['valor'] ?? 0);
    $categoria = trim($_POST['categoria'] ?? '');
    $status = ($_POST['status'] ?? 'inativo') === 'ativo' ? 'ativo' : 'inativo';

    $imagens = [];

    // Upload de múltiplas imagens
    if(isset($_FILES['imagens'])){
        foreach($_FILES['imagens']['tmp_name'] as $i => $tmpName){
            if($_FILES['imagens']['error'][$i] === UPLOAD_ERR_OK){
                $ext = pathinfo($_FILES['imagens']['name'][$i], PATHINFO_EXTENSION);
                $novoNome = uniqid().'_'.$i.'.'.$ext;
                if(move_uploaded_file($tmpName, $uploadDir.$novoNome)){
                    $imagens[] = 'uploads/'.$novoNome;
                }
            }
        }
    }

    // Cria novo produto
    $novoProduto = [
        'id' => uniqid(),
        'id_parceiro' => $parceiro_logado,
        'nome' => $nome,
        'descricao' => $descricao,
        'valor' => $valor,
        'categoria' => $categoria,
        'status' => $status,
        'imagens' => $imagens,
        'criado_em' => date('c')
    ];

    $produtosData = json_decode(file_get_contents($produtosJson), true);
    $produtosData[] = $novoProduto;
    file_put_contents($produtosJson, json_encode($produtosData, JSON_PRETTY_PRINT));

    $_SESSION['produto_salvo'] = true;
    header("Location: adicionar_produto.php");
    exit;
}
?>

<?php include('includes/header.php'); ?>

<main class="pt-24 px-4 sm:px-6 lg:px-8 max-w-5xl mx-auto">
    <h1 class="text-2xl font-bold mb-6 text-[var(--text-primary)]">Adicionar Produto</h1>

    <!-- Formulário -->
    <form method="POST" enctype="multipart/form-data" class="bg-[var(--menu-secondary)] dark:bg-[var(--menu-secondary)] shadow rounded p-6 border border-[var(--border-color)]">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Nome</label>
                <input type="text" name="nome" required class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
            </div>
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Valor (R$)</label>
                <input type="number" name="valor" step="0.01" required class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
            </div>
            <div class="md:col-span-2">
                <label class="block mb-1 text-[var(--text-secondary)]">Descrição</label>
                <textarea name="descricao" rows="3" class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]"></textarea>
            </div>
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Categoria</label>
                <input type="text" name="categoria" class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
            </div>
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Status</label>
                <select name="status" class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
                    <option value="ativo">Ativo</option>
                    <option value="inativo">Inativo</option>
                </select>
            </div>
            <div class="md:col-span-2">
                <label class="block mb-1 text-[var(--text-secondary)]">Imagens (upload)</label>
                <input type="file" name="imagens[]" accept="image/*" multiple class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]" id="imagensInput">
                <div id="previewImagens" class="mt-2 flex flex-wrap gap-2"></div>
            </div>
        </div>

        <div class="mt-4 flex flex-col sm:flex-row gap-2">
            <button type="submit" class="bg-[var(--accent)] text-white px-6 py-2 rounded shadow hover:bg-[var(--accent)]/90 flex-1">Salvar</button>
            <a href="produtos.php" class="bg-gray-400 text-white px-6 py-2 rounded shadow hover:bg-gray-500 flex-1 text-center">Cancelar</a>
        </div>
    </form>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Preview das imagens
document.getElementById('imagensInput').addEventListener('change', function(){
    const preview = document.getElementById('previewImagens');
    preview.innerHTML = '';
    Array.from(this.files).forEach(file => {
        const reader = new FileReader();
        reader.onload = function(e){
            const img = document.createElement('img');
            img.src = e.target.result;
            img.className = 'w-20 h-20 object-cover rounded border border-gray-300';
            preview.appendChild(img);
        };
        reader.readAsDataURL(file);
    });
});

// SweetAlert2 após salvar
<?php
if(isset($_SESSION['produto_salvo']) && $_SESSION['produto_salvo']){
    echo "document.addEventListener('DOMContentLoaded', function(){
        Swal.fire({
            icon: 'success',
            title: 'Produto salvo!',
            text: 'O produto foi adicionado com sucesso.',
            confirmButtonColor: '#0088CC'
        });
    });";
    unset($_SESSION['produto_salvo']);
}
?>
</script>