<?php
set_time_limit(0);

$base = 'https://ntindica.com.br';
$saida = __DIR__ . '/dump';

@mkdir($saida, 0777, true);

/**
 * LISTA DE ARQUIVOS PHP CONHECIDOS / COMUNS
 */
$arquivos = [
    'index.php',
    'painel.php',
    'admin.php',
    'admin_login.php',
    'login.php',
    'logout.php',
    'clientes.php',
    'usuarios.php',
    'config.php'
];

/**
 * POSSÍVEIS TABS DO ADMIN
 */
$tabs = [
    '',
    'clientes',
    'usuarios',
    'parceiros',
    'config',
    'financeiro',
    'relatorios',
    'saques'
];

function salvar($url, $arquivo) {
    $html = @file_get_contents($url);
    if (!$html) return false;

    @mkdir(dirname($arquivo), 0777, true);
    file_put_contents($arquivo, $html);
    echo "OK: $url\n";
    return true;
}

foreach ($arquivos as $file) {
    // página direta
    salvar("$base/$file", "$saida/$file.html");

    // tabs
    if ($file === 'admin.php') {
        foreach ($tabs as $tab) {
            $url = $tab ? "$base/admin.php?tab=$tab" : "$base/admin.php";
            $nome = $tab ?: 'home';
            salvar($url, "$saida/admin/$nome.html");
        }
    }
}

echo "FINALIZADO\n";