<?php
/**
 * Central de Downloads - Layout Original com Menu Separado
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$pedidos_file = $base_path . 'pedidos.json';

function load_json_data($file) {
    if (!file_exists($file)) return [];
    $content = file_get_contents($file);
    return json_decode($content, true) ?: [];
}

$parceiros = load_json_data($parceiros_file);
$parceiro = null;
foreach($parceiros as $p){
    if((string)($p['id'] ?? '') === $idParceiro){
        $parceiro = $p;
        break;
    }
}

if(!$parceiro) {
    $parceiro = ['nome' => 'Loja Parceira', 'cor_primaria' => '#2563eb'];
}

$idCliente = isset($_GET['cliente_id']) ? (string)$_GET['cliente_id'] : '';

$pedidos = load_json_data($pedidos_file);
$meusProdutos = [];

if ($idCliente) {
    foreach($pedidos as $p){
        if($p['id_cliente'] === $idCliente && $p['status_pagamento'] === 'pago'){
            foreach($p['arquivos'] as $arq) {
                $meusProdutos[$arq['file']] = [
                    'nome' => $arq['nome'],
                    'imagem' => $arq['imagem'] ?? ''
                ];
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Meus Produtos | <?= htmlspecialchars($parceiro['nome']) ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>
    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; }
        
        header {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid #e2e8f0;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .badge-cart {
            background: #ef4444;
            color: white;
            font-size: 10px;
            font-weight: 700;
            padding: 2px 6px;
            border-radius: 10px;
            position: absolute;
            top: -5px;
            right: -5px;
            border: 2px solid #fff;
        }

        .btn-primary { background-color: var(--p-color); color: #fff !important; }
    </style>
</head>
<body class="min-h-screen flex flex-col">

<?php include 'includes/menu.php'; ?>

<main class="max-w-5xl mx-auto px-4 py-10 w-full">
    <div id="authCheck" class="hidden">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-12 text-center">
            <i class="ph ph-lock-key text-5xl text-slate-200 mb-4"></i>
            <h2 class="text-xl font-bold text-slate-800 mb-2">Acesso Restrito</h2>
            <p class="text-slate-500 text-sm mb-6">Você precisa estar logado para acessar seus downloads.</p>
            <a href="carrinho.php?id=<?= $idParceiro ?>" class="btn-primary px-8 py-3 rounded-xl font-bold text-xs uppercase tracking-widest inline-block">Fazer Login</a>
        </div>
    </div>

    <div id="contentView" class="hidden">
        <div class="mb-8">
            <h1 class="text-3xl font-black text-slate-800 tracking-tighter uppercase italic">Meus Produtos</h1>
            <p class="text-slate-500 text-sm">Aqui estão todos os itens que você já adquiriu.</p>
        </div>

        <?php if (empty($meusProdutos) && $idCliente): ?>
            <div class="bg-white rounded-2xl border border-dashed border-slate-200 p-20 text-center">
                <i class="ph ph-shopping-bag-open text-5xl text-slate-200 mb-4"></i>
                <p class="text-slate-400 font-medium">Você ainda não possui produtos pagos.</p>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <?php foreach ($meusProdutos as $file => $info): ?>
                    <div class="bg-white p-5 rounded-2xl border border-slate-100 flex items-center justify-between group hover:border-primary transition-all shadow-sm">
                        <div class="flex items-center gap-4">
                            <div class="w-12 h-12 bg-slate-50 rounded-xl flex items-center justify-center text-primary border border-slate-100 overflow-hidden">
                                <?php if(!empty($info['imagem'])): ?>
                                    <img src="<?= htmlspecialchars($info['imagem']) ?>" class="w-full h-full object-contain">
                                <?php else: ?>
                                    <i class="ph-fill ph-file-zip text-2xl"></i>
                                <?php endif; ?>
                            </div>
                            <div>
                                <h3 class="font-bold text-slate-800 text-sm"><?= htmlspecialchars($info['nome']) ?></h3>
                                <p class="text-[10px] text-slate-400 font-bold uppercase">Disponível para Download</p>
                            </div>
                        </div>
                        <a href="<?= htmlspecialchars($file) ?>" download class="w-10 h-10 bg-slate-50 text-slate-400 rounded-lg flex items-center justify-center group-hover:bg-primary group-hover:text-white transition-all">
                            <i class="ph-bold ph-download-simple"></i>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</main>

<script>
    const idParceiro = '<?= $idParceiro ?>';
    const cliente = JSON.parse(localStorage.getItem('cliente_logado_' + idParceiro));

    if (!cliente) {
        document.getElementById('authCheck').classList.remove('hidden');
    } else {
        const urlParams = new URLSearchParams(window.location.search);
        if (!urlParams.has('cliente_id')) {
            window.location.href = `downloads.php?id=${idParceiro}&cliente_id=${cliente.id}`;
        } else {
            document.getElementById('contentView').classList.remove('hidden');
        }
    }
</script>

</body>
</html>
