<?php
/**
 * Página de Carrinho - Seguindo o Layout Solicitado
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$clientes_file  = $base_path . 'clientes.json';
$pedidos_file   = $base_path . 'pedidos.json';

function load_json_data($file) {
    if (!file_exists($file)) return [];
    $content = file_get_contents($file);
    return json_decode($content, true) ?: [];
}

function save_json_data($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$parceiros = load_json_data($parceiros_file);
$parceiro = null;
foreach($parceiros as $p){
    if((string)($p['id'] ?? '') === $idParceiro){
        $parceiro = $p;
        break;
    }
}

if(!$parceiro) {
    $parceiro = ['nome' => 'Loja Parceira', 'cor_primaria' => '#2563eb', 'token' => ''];
}

// API Interna
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $clientes = load_json_data($clientes_file);

    if ($_POST['action'] === 'login') {
        $email = $_POST['email'] ?? '';
        $senha = $_POST['senha'] ?? '';
        foreach ($clientes as $c) {
            if ($c['email'] === $email && $c['senha'] === $senha && $c['id_parceiro'] === $idParceiro) {
                echo json_encode(['success' => true, 'cliente' => $c]);
                exit;
            }
        }
        echo json_encode(['success' => false, 'message' => 'E-mail ou senha incorretos.']);
        exit;
    }

    if ($_POST['action'] === 'cadastrar') {
        $email = $_POST['email'] ?? '';
        foreach ($clientes as $c) {
            if ($c['email'] === $email && $c['id_parceiro'] === $idParceiro) {
                echo json_encode(['success' => false, 'message' => 'E-mail já cadastrado.']);
                exit;
            }
        }
        $novoCliente = [
            "id" => "c" . uniqid(),
            "id_parceiro" => $idParceiro,
            "nome" => $_POST['nome'],
            "email" => $email,
            "senha" => $_POST['senha'],
            "whatsapp" => $_POST['whatsapp'],
            "saldo" => 0.0,
            "status" => "ativo",
            "criado_em" => date('c')
        ];
        $clientes[] = $novoCliente;
        save_json_data($clientes_file, $clientes);
        echo json_encode(['success' => true, 'cliente' => $novoCliente]);
        exit;
    }

    if ($_POST['action'] === 'finalizar_pedido') {
        $idCliente = $_POST['id_cliente'] ?? '';
        $valorTotal = (float)($_POST['valor_total'] ?? 0);
        $metodo = $_POST['metodo_pagamento'] ?? '';
        $itens = json_decode($_POST['itens'] ?? '[]', true);

        if (empty($idCliente) || empty($itens) || $valorTotal <= 0) {
            echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
            exit;
        }

        $clienteIndex = -1;
        foreach ($clientes as $idx => $c) {
            if ($c['id'] === $idCliente) { $clienteIndex = $idx; break; }
        }

        if ($clienteIndex === -1) { echo json_encode(['success' => false, 'message' => 'Cliente não encontrado.']); exit; }

        $statusPagamento = 'pendente';
        if ($metodo === 'saldo') {
            if ($clientes[$clienteIndex]['saldo'] < $valorTotal) {
                echo json_encode(['success' => false, 'message' => 'Saldo insuficiente.']);
                exit;
            }
            $clientes[$clienteIndex]['saldo'] -= $valorTotal;
            save_json_data($clientes_file, $clientes);
            $statusPagamento = 'pago';
        }

        $pedidos = load_json_data($pedidos_file);
        $pedidoId = "p" . date('YmdHis') . rand(10, 99);
        $novoPedido = [
            "id" => $pedidoId,
            "id_parceiro" => $idParceiro,
            "id_cliente" => $idCliente,
            "valor_total" => $valorTotal,
            "metodo" => $metodo,
            "status_pagamento" => $statusPagamento,
            "arquivos" => array_map(fn($i) => ['nome' => $i['nome'], 'file' => $i['file']], $itens),
            "data" => date('c')
        ];
        $pedidos[] = $novoPedido;
        save_json_data($pedidos_file, $pedidos);

        $pixData = null;
        if ($metodo === 'pix') {
            $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
            $host = $_SERVER['HTTP_HOST'];
            $webhookUrl = "$protocol://$host/webhook.php";

            $ch = curl_init('https://api.pushinpay.com.br/api/pix/cashIn');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                "value" => (int)($valorTotal * 100),
                "webhook_url" => $webhookUrl,
                "external_id" => $pedidoId
            ]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . ($parceiro['token'] ?? ''),
                'Accept: application/json',
                'Content-Type: application/json'
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);
            $pixData = json_decode($response, true);
        }

        echo json_encode([
            'success' => true, 
            'pedido_id' => $pedidoId,
            'status_pagamento' => $statusPagamento,
            'pix' => $pixData,
            'novo_saldo' => $clientes[$clienteIndex]['saldo']
        ]);
        exit;
    }

    if ($_POST['action'] === 'verificar_status') {
        $pedidoId = $_POST['pedido_id'];
        $pedidos = load_json_data($pedidos_file);
        foreach ($pedidos as $p) {
            if ($p['id'] === $pedidoId) {
                echo json_encode(['status' => $p['status_pagamento']]);
                exit;
            }
        }
        echo json_encode(['status' => 'nao_encontrado']);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Carrinho | <?= htmlspecialchars($parceiro['nome']) ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>
    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; }
        .btn-primary { background-color: var(--p-color); color: #fff !important; transition: all 0.3s; }
        .btn-primary:hover { opacity: 0.9; transform: translateY(-1px); }
        .card-checkout { background: #fff; border: 1px solid #e2e8f0; border-radius: 12px; }
        .input-checkout { width: 100%; padding: 12px; border-radius: 8px; border: 1px solid #e2e8f0; outline: none; }
        .input-checkout:focus { border-color: var(--p-color); }
        .metodo-card { border: 2px solid #f1f5f9; border-radius: 12px; cursor: pointer; transition: all 0.2s; }
        .metodo-card.active { border-color: var(--p-color); background: rgba(var(--p-color), 0.02); }
        .pix-container { background: #fff; border-radius: 16px; padding: 20px; text-align: center; }
        .copy-box { background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 8px; padding: 10px; font-family: monospace; font-size: 11px; word-break: break-all; margin: 15px 0; }
    </style>
</head>
<body>

<header class="bg-white border-b border-slate-200 sticky top-0 z-50">
    <div class="max-w-6xl mx-auto px-4 h-16 flex justify-between items-center">
        <a href="index.php?id=<?= $idParceiro ?>" class="flex items-center gap-2 text-slate-600 hover:text-primary font-bold text-sm">
            <i class="ph-bold ph-arrow-left"></i> Voltar
        </a>
        <h1 class="font-bold text-lg text-slate-800">Meu Carrinho</h1>
        <div class="w-10"></div>
    </div>
</header>

<main class="max-w-6xl mx-auto px-4 py-10">
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
        
        <div class="lg:col-span-7 space-y-6">
            <section class="card-checkout p-6">
                <h2 class="font-bold text-slate-800 mb-6 flex items-center gap-2">
                    <i class="ph ph-shopping-cart text-primary"></i> Itens Selecionados
                </h2>
                <div id="cartItemsList" class="divide-y divide-slate-100"></div>
                <div id="emptyCart" class="hidden py-10 text-center text-slate-400">Seu carrinho está vazio.</div>
            </section>

            <section id="sectionAuth" class="card-checkout p-6">
                <div id="authContent">
                    <div class="flex gap-6 mb-6 border-b border-slate-100">
                        <button onclick="switchTab('login')" id="tabLogin" class="pb-3 font-bold text-sm border-b-2 border-primary text-primary">Entrar</button>
                        <button onclick="switchTab('cadastro')" id="tabCadastro" class="pb-3 font-bold text-sm border-b-2 border-transparent text-slate-400">Criar Conta</button>
                    </div>
                    
                    <div id="loginForm" class="space-y-4">
                        <input type="email" id="loginEmail" class="input-checkout" placeholder="E-mail">
                        <input type="password" id="loginSenha" class="input-checkout" placeholder="Senha">
                        <button onclick="realizarLogin()" class="btn-primary w-full py-3 rounded-lg font-bold">Acessar Conta</button>
                    </div>

                    <div id="cadastroForm" class="hidden space-y-4">
                        <input type="text" id="regNome" class="input-checkout" placeholder="Nome Completo">
                        <input type="email" id="regEmail" class="input-checkout" placeholder="E-mail">
                        <input type="password" id="regSenha" class="input-checkout" placeholder="Senha">
                        <input type="text" id="regWhatsapp" class="input-checkout" placeholder="WhatsApp">
                        <button onclick="realizarCadastro()" class="btn-primary w-full py-3 rounded-lg font-bold">Cadastrar e Continuar</button>
                    </div>
                </div>

                <div id="clienteLogadoView" class="hidden flex items-center justify-between bg-slate-50 p-4 rounded-xl border border-slate-100">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-primary/10 rounded-full flex items-center justify-center text-primary"><i class="ph-fill ph-user"></i></div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase">Logado como</p>
                            <p id="displayNome" class="font-bold text-slate-800"></p>
                        </div>
                    </div>
                    <button onclick="logout()" class="text-xs font-bold text-red-500">SAIR</button>
                </div>
            </section>
        </div>

        <div class="lg:col-span-5 space-y-6">
            <div class="card-checkout p-6 sticky top-24">
                <h2 class="text-lg font-bold text-slate-800 mb-6">Resumo do Pedido</h2>
                
                <div class="space-y-3 mb-6">
                    <div class="flex justify-between text-slate-500"><span>Subtotal</span><span id="subtotalValue">R$ 0,00</span></div>
                    <div class="flex justify-between text-slate-500"><span>Entrega</span><span class="text-green-600">Grátis</span></div>
                    <div class="pt-4 border-t border-slate-100 flex justify-between items-center">
                        <span class="font-bold text-slate-800">Total</span>
                        <span id="totalValue" class="text-2xl font-black text-slate-900">R$ 0,00</span>
                    </div>
                </div>

                <div id="saldoContainer" class="hidden mb-6 p-4 bg-primary/5 rounded-xl border border-primary/10">
                    <div class="flex justify-between items-center mb-1">
                        <span class="text-[10px] font-bold text-primary uppercase">Saldo Disponível</span>
                        <i class="ph ph-wallet text-primary"></i>
                    </div>
                    <div id="saldoDisplay" class="text-xl font-black text-primary">R$ 0,00</div>
                </div>

                <div class="space-y-3 mb-6">
                    <p class="text-[10px] font-bold text-slate-400 uppercase">Forma de Pagamento</p>
                    <div class="grid grid-cols-2 gap-3">
                        <div onclick="setMetodo('saldo')" id="cardSaldo" class="metodo-card p-3 flex flex-col items-center gap-1 active">
                            <i class="ph ph-wallet text-xl text-slate-400"></i>
                            <span class="text-[10px] font-bold uppercase">Saldo</span>
                        </div>
                        <div onclick="setMetodo('pix')" id="cardPix" class="metodo-card p-3 flex flex-col items-center gap-1">
                            <i class="ph ph-qr-code text-xl text-slate-400"></i>
                            <span class="text-[10px] font-bold uppercase">Pix</span>
                        </div>
                    </div>
                </div>

                <div class="bg-amber-50 p-3 rounded-lg border border-amber-100 mb-6">
                    <p class="text-[10px] text-amber-700 leading-tight">
                        <i class="ph-bold ph-info mr-1"></i> O acesso aos arquivos será liberado imediatamente após a aprovação do pagamento.
                    </p>
                </div>

                <button onclick="finalizarPedido()" id="btnFinalizar" class="btn-primary w-full py-4 rounded-xl font-bold text-sm uppercase tracking-wider shadow-lg">
                    Finalizar Pedido
                </button>
            </div>
        </div>
    </div>
</main>

<script>
    let carrinho = JSON.parse(localStorage.getItem('carrinho_<?= $idParceiro ?>')) || [];
    const idParceiro = '<?= $idParceiro ?>';
    let metodoPagamento = 'saldo';

    function renderCart() {
        const list = document.getElementById('cartItemsList');
        if (carrinho.length === 0) { list.innerHTML = ''; document.getElementById('emptyCart').classList.remove('hidden'); return; }
        document.getElementById('emptyCart').classList.add('hidden');

        const grouped = carrinho.reduce((acc, item) => {
            if (!acc[item.id]) acc[item.id] = { ...item, qty: 0 };
            acc[item.id].qty++; return acc;
        }, {});

        list.innerHTML = Object.values(grouped).map(item => `
            <div class="py-4 flex items-center gap-4">
                <div class="w-12 h-12 bg-slate-50 rounded-lg flex items-center justify-center p-1 border border-slate-100">
                    <img src="${item.imagens[0]}" class="max-w-full max-h-full object-contain">
                </div>
                <div class="flex-grow">
                    <h4 class="font-bold text-slate-800 text-xs">${item.nome}</h4>
                    <span class="text-primary font-bold text-xs">R$ ${item.valor.toLocaleString('pt-BR', {minimumFractionDigits: 2})}</span>
                </div>
                <div class="flex items-center gap-2 bg-slate-50 px-2 py-1 rounded-lg">
                    <button onclick="updateQty('${item.id}', -1)" class="text-slate-400 hover:text-primary"><i class="ph-bold ph-minus text-[10px]"></i></button>
                    <span class="font-bold text-xs w-4 text-center">${item.qty}</span>
                    <button onclick="updateQty('${item.id}', 1)" class="text-slate-400 hover:text-primary"><i class="ph-bold ph-plus text-[10px]"></i></button>
                </div>
                <button onclick="removeItem('${item.id}')" class="text-slate-300 hover:text-red-500"><i class="ph-bold ph-trash text-lg"></i></button>
            </div>
        `).join('');
        updateTotals();
        verificarLogin();
    }

    function updateQty(id, delta) {
        if (delta > 0) { const item = carrinho.find(i => i.id === id); carrinho.push({...item}); }
        else { const index = carrinho.findLastIndex(i => i.id === id); if (index !== -1) carrinho.splice(index, 1); }
        localStorage.setItem('carrinho_<?= $idParceiro ?>', JSON.stringify(carrinho));
        renderCart();
    }

    function removeItem(id) {
        carrinho = carrinho.filter(i => i.id !== id);
        localStorage.setItem('carrinho_<?= $idParceiro ?>', JSON.stringify(carrinho));
        renderCart();
    }

    function updateTotals() {
        const total = carrinho.reduce((sum, item) => sum + item.valor, 0);
        const formatted = total.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
        document.getElementById('subtotalValue').textContent = formatted;
        document.getElementById('totalValue').textContent = formatted;
    }

    function setMetodo(metodo) {
        metodoPagamento = metodo;
        document.getElementById('cardSaldo').classList.toggle('active', metodo === 'saldo');
        document.getElementById('cardPix').classList.toggle('active', metodo === 'pix');
    }

    function switchTab(tab) {
        document.getElementById('loginForm').classList.toggle('hidden', tab !== 'login');
        document.getElementById('cadastroForm').classList.toggle('hidden', tab !== 'cadastro');
        document.getElementById('tabLogin').className = tab === 'login' ? 'pb-3 font-bold text-sm border-b-2 border-primary text-primary' : 'pb-3 font-bold text-sm border-b-2 border-transparent text-slate-400';
        document.getElementById('tabCadastro').className = tab === 'cadastro' ? 'pb-3 font-bold text-sm border-b-2 border-primary text-primary' : 'pb-3 font-bold text-sm border-b-2 border-transparent text-slate-400';
    }

    function verificarLogin() {
        const cliente = JSON.parse(localStorage.getItem('cliente_logado_<?= $idParceiro ?>'));
        if (cliente) {
            document.getElementById('authContent').classList.add('hidden');
            document.getElementById('clienteLogadoView').classList.remove('hidden');
            document.getElementById('displayNome').textContent = cliente.nome;
            document.getElementById('saldoContainer').classList.remove('hidden');
            document.getElementById('saldoDisplay').textContent = new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(cliente.saldo);
            return cliente;
        } else {
            document.getElementById('authContent').classList.remove('hidden');
            document.getElementById('clienteLogadoView').classList.add('hidden');
            document.getElementById('saldoContainer').classList.add('hidden');
            return null;
        }
    }

    async function realizarLogin() {
        const email = document.getElementById('loginEmail').value;
        const senha = document.getElementById('loginSenha').value;
        if (!email || !senha) return Swal.fire('Atenção', 'Preencha todos os campos.', 'warning');
        const formData = new FormData();
        formData.append('action', 'login');
        formData.append('email', email);
        formData.append('senha', senha);
        const response = await fetch(window.location.href, { method: 'POST', body: formData });
        const res = await response.json();
        if (res.success) { localStorage.setItem('cliente_logado_<?= $idParceiro ?>', JSON.stringify(res.cliente)); renderCart(); }
        else { Swal.fire('Erro', res.message, 'error'); }
    }

    async function realizarCadastro() {
        const nome = document.getElementById('regNome').value;
        const email = document.getElementById('regEmail').value;
        const senha = document.getElementById('regSenha').value;
        const whatsapp = document.getElementById('regWhatsapp').value;
        if (!nome || !email || !senha || !whatsapp) return Swal.fire('Atenção', 'Preencha todos os campos.', 'warning');
        const formData = new FormData();
        formData.append('action', 'cadastrar');
        formData.append('nome', nome);
        formData.append('email', email);
        formData.append('senha', senha);
        formData.append('whatsapp', whatsapp);
        const response = await fetch(window.location.href, { method: 'POST', body: formData });
        const res = await response.json();
        if (res.success) { localStorage.setItem('cliente_logado_<?= $idParceiro ?>', JSON.stringify(res.cliente)); renderCart(); }
        else { Swal.fire('Erro', res.message, 'error'); }
    }

    function logout() { localStorage.removeItem('cliente_logado_<?= $idParceiro ?>'); renderCart(); }

    async function finalizarPedido() {
        const cliente = verificarLogin();
        if (!cliente) return Swal.fire('Identificação', 'Faça login para finalizar.', 'info');
        if (carrinho.length === 0) return Swal.fire('Carrinho Vazio', 'Adicione itens antes de finalizar.', 'warning');
        
        const total = carrinho.reduce((sum, item) => sum + item.valor, 0);
        if (metodoPagamento === 'saldo' && total > cliente.saldo) return Swal.fire('Saldo Insuficiente', 'Seu saldo não cobre o valor total.', 'error');

        Swal.fire({ title: 'Processando...', allowOutsideClick: false, didOpen: () => { Swal.showLoading(); } });

        const formData = new FormData();
        formData.append('action', 'finalizar_pedido');
        formData.append('id_cliente', cliente.id);
        formData.append('itens', JSON.stringify(carrinho));
        formData.append('valor_total', total);
        formData.append('metodo_pagamento', metodoPagamento);

        const response = await fetch(window.location.href, { method: 'POST', body: formData });
        const res = await response.json();
        
        if (res.success) {
            if (metodoPagamento === 'pix' && res.pix) {
                Swal.fire({
                    title: 'Pagamento via Pix',
                    html: `
                        <div class="pix-container">
                            <img src="${res.pix.qr_code_base64}" class="mx-auto w-40 h-40 mb-4">
                            <p class="text-[10px] font-bold text-slate-400 uppercase">Copia e Cola</p>
                            <div class="copy-box" id="pixCode">${res.pix.qr_code}</div>
                            <button onclick="copyPix()" class="bg-primary text-white px-6 py-3 rounded-lg text-xs font-bold uppercase w-full">Copiar Código</button>
                            <div class="mt-6 flex items-center justify-center gap-2 text-primary animate-pulse">
                                <i class="ph-bold ph-circle-notch animate-spin"></i>
                                <span class="text-[10px] font-bold uppercase">Aguardando Pagamento...</span>
                            </div>
                        </div>
                    `,
                    showConfirmButton: false,
                    allowOutsideClick: false
                });

                window.copyPix = () => {
                    navigator.clipboard.writeText(res.pix.qr_code);
                    Swal.showValidationMessage('Código copiado!');
                    setTimeout(() => Swal.resetValidationMessage(), 2000);
                };

                const checkStatus = setInterval(async () => {
                    const checkData = new FormData();
                    checkData.append('action', 'verificar_status');
                    checkData.append('pedido_id', res.pedido_id);
                    const checkRes = await fetch(window.location.href, { method: 'POST', body: checkData });
                    const statusRes = await checkRes.json();
                    
                    if (statusRes.status === 'pago') {
                        clearInterval(checkStatus);
                        Swal.fire({ icon: 'success', title: 'Pago!', text: 'Pagamento confirmado.', timer: 2000, showConfirmButton: false }).then(() => {
                            carrinho = [];
                            localStorage.setItem('carrinho_<?= $idParceiro ?>', JSON.stringify(carrinho));
                            window.location.href = `downloads.php?id=${idParceiro}&pedido=${res.pedido_id}`;
                        });
                    }
                }, 3000);
            } else {
                if (metodoPagamento === 'saldo') {
                    cliente.saldo = res.novo_saldo;
                    localStorage.setItem('cliente_logado_<?= $idParceiro ?>', JSON.stringify(cliente));
                }
                Swal.fire({ icon: 'success', title: 'Sucesso!', text: 'Pedido realizado.', timer: 2000, showConfirmButton: false }).then(() => {
                    carrinho = [];
                    localStorage.setItem('carrinho_<?= $idParceiro ?>', JSON.stringify(carrinho));
                    window.location.href = `downloads.php?id=${idParceiro}&pedido=${res.pedido_id}`;
                });
            }
        } else {
            Swal.fire('Erro', res.message, 'error');
        }
    }

    renderCart();
</script>

</body>
</html>
