
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>NT Indica - Entrar</title>
    <link rel="icon" type="image/x-icon" href="imagem/favicon.ico">
    
    <!-- FONTES -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- ÍCONES (Adicionado para o check funcionar) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <style>
        /* TEMA MODERNO - COERÊNCIA COM O PAINEL */
        
        * {
            box-sizing: border-box;
        }

        html, body {
            height: 100%; 
            width: 100%;
            overflow: hidden; /* Bloqueia a barra de rolagem da página inteira */
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); /* Fundo Roxo/Azul */
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .card {
            background: white;
            padding: 35px; /* Ajustado levemente */
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            
            /* --- AQUI ESTÁ A MUDANÇA PARA FICAR MAIS LARGO --- */
            width: 90%; /* Ocupa 90% da largura da tela no celular */
            max-width: 420px; /* Aumentei de 350px para 420px */
            /* ------------------------------------------------- */
            
            text-align: center;
            transition: all 0.3s;
            
            /* Se a tela for muito pequena (celular deitado), o scroll aparece DENTRO do card */
            max-height: 90vh;
            overflow-y: auto; 
        }

        /* Esconde a barra de rolagem interna do card para ficar mais bonito */
        .card::-webkit-scrollbar { width: 0px; background: transparent; }

        h2 {
            margin-top: 0;
            color: #4a5568;
            font-weight: 700;
            font-size: 1.5rem;
            margin-bottom: 20px;
        }

        input {
            width: 100%;
            padding: 14px;
            margin: 10px 0;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 0.95rem;
            transition: border-color 0.3s;
            background: #f7fafc;
        }
        input:focus {
            border-color: #667eea;
            outline: none;
            background: white;
        }

        button {
            width: 100%;
            padding: 14px;
            background: #3699ff; /* Azul do tema */
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
            font-size: 1rem;
            margin-top: 15px;
            transition: background 0.3s;
        }
        button:hover {
            background: #2b6cb0;
        }

        a {
            color: #2b6cb0; /* Azul do tema */
            text-decoration: none;
            display: block;
            margin-top: 20px;
            font-size: 0.9rem;
            font-weight: 600;
            transition: color 0.3s;
        }
        a:hover {
            color: #3699ff;
        }

        /* MENSAGENS (ERRO E SUCESSO) */
        .msg {
            padding: 12px;
            margin-bottom: 15px;
            border-radius: 8px;
            font-size: 0.9rem;
            font-weight: 600;
        }
        
        .error {
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
        }

        /* CLASSE NOVA PARA A MENSAGEM DE CADASTRO */
        .success {
            background: #dcfce7;
            color: #166534;
            border: 1px solid #bbf7d0;
            text-align: center;
        }

        /* ESTILOS DE BRANDING */
        .logo-container { margin-bottom: 15px; }
        .logo-img { max-height: 70px; width: auto; max-width: 90%; } /* Aumentei um pouco o limite da logo */
        .brand-name { display: block; font-size: 1.2em; font-weight: 700; color: #2d3748; }
    </style>
</head>
<body>
    <div class="card">
        <div class="logo-container">
                             <img src="imagem/logo.png" alt="Logo Empresa" class="logo-img">
                    </div>
        
        <h2>Acesso ao Painel</h2>

        <!-- AQUI ENTRA A MENSAGEM DE SUCESSO DO CADASTRO -->
        
                
        <form method="POST">
            <input type="email" name="email" placeholder="Seu E-mail" required>
            <input type="password" name="senha" placeholder="Sua Senha" required>
            <button type="submit" name="logar">Entrar</button>
        </form>
        
        <!-- Adicionei um link para voltar para criar conta, caso ele tenha clicado errado -->
        
    </div>
</body>
</html>