<?php
// includes/header.php
?>

<!DOCTYPE html>
<html lang="pt-BR" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>

    <!-- Tailwind -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
:root {
    --accent: #0088CC;
    --header-bg: #0088CC;
    --header-text: #FFFFFF;
    --menu-bg: #FFFFFF;
    --menu-secondary: #F5F5F5;
    --body-bg: #FFFFFF;
    --text-primary: #2E2E2E;
    --text-secondary: #757575;
    --border-color: #E0E0E0;
}

.dark {
    --accent: #34AADF;
    --header-bg: #0E1621;
    --header-text: #FFFFFF;
    --menu-bg: rgba(14, 22, 33, 0.85);
    --menu-secondary: rgba(22, 32, 45, 0.80);
    --body-bg: #17212b;
    --text-primary: #FFFFFF;
    --text-secondary: #A8B8C5;
    --border-color: #263544;
}

body {
    background: var(--body-bg);
    color: var(--text-primary);
    transition: 0.3s;
}

header {
    background: var(--header-bg) !important;
    color: var(--header-text) !important;
    backdrop-filter: blur(10px);
}

#menuLateral {
    background: var(--menu-bg) !important;
    backdrop-filter: blur(20px);
}

.menu-item {
    background: var(--menu-secondary);
    color: var(--text-primary);
    border: 1px solid var(--border-color);
    transition: 0.25s;
}

.menu-item:hover {
    background: var(--accent);
    color: white !important;
    border-color: var(--accent);
}

#whatsappBtn {
    position: fixed;
    bottom: 22px;
    right: 22px;
    z-index: 60;
    background: #25D366;
    color: white;
    width: 60px;
    height: 60px;
    font-size: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 12px rgba(0,0,0,0.25);
}
/* Seções do menu lateral */
.menu-section {
    display: block;
    padding: 5px 15px;
    font-size: 0.75rem;  /* menor que os itens */
    font-weight: 600;
    color: #6b7280;       /* cinza mais suave */
    margin-top: 10px;
    text-transform: uppercase;
    pointer-events: none; /* não clicável */
}
</style>

</head>
<body class="transition duration-300">

<!-- OVERLAY -->
<div id="overlay" class="fixed inset-0 bg-black bg-opacity-40 opacity-0 pointer-events-none transition-opacity duration-300 z-30"></div>

<!-- HEADER -->
<header class="w-full shadow-md py-4 px-6 flex items-center justify-between fixed top-0 left-0 z-50">
    <div class="flex items-center gap-3">
        <i class="fa-solid fa-bars text-2xl cursor-pointer" id="btnMenu"></i>
        <i class="fa-solid fa-xmark text-2xl cursor-pointer hidden" id="btnCloseMain"></i>
        <img src="img/logo.png" alt="logo" class="h-10">
    </div>

    <div class="flex items-center gap-6">
        <a href="aviso.php">
            <i class="fa-regular fa-bell text-xl cursor-pointer hover:text-gray-200 transition"></i>
        </a>
        <i id="toggleTheme" class="fa-solid fa-circle-half-stroke text-xl cursor-pointer hover:text-gray-200 transition"></i>
        <a href="perfil.php">
            <i class="fa-solid fa-circle-user text-2xl cursor-pointer hover:text-gray-200 transition"></i>
        </a>
    </div>
</header>

<!-- MENU LATERAL -->
<aside id="menuLateral" class="fixed top-0 left-0 w-64 h-full shadow-2xl transform -translate-x-full transition-all duration-300 z-40">

    <div class="p-6 flex items-center justify-between border-b" style="border-color: var(--border-color);">
        <span class="text-lg font-semibold">Menu</span>
        <i class="fa-solid fa-xmark text-xl cursor-pointer" id="closeMenu"></i>
    </div>

    <nav class="p-4 flex flex-col gap-1">
    <!-- Principal -->
<span class="menu-section">Principal</span>
<a href="clientes.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-users mr-2"></i> Clientes</a>
<a href="pedidos.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-cart-shopping mr-2"></i> Pedidos</a>
<a href="solicitacoes.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-envelope-open-text mr-2"></i> Solicitações</a>

<!-- Catálogo -->
<span class="menu-section">Catálogo</span>
<a href="produtos.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-box-open mr-2"></i> Produtos</a>

<!-- Administração -->
<span class="menu-section">Administração</span>
<a href="perfil.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-gear mr-2"></i> Configurações</a>
<a href="log.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-file-lines mr-2"></i> Logs</a>
<a href="instalar_app.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-download mr-2"></i> Instalar App</a>

<!-- Revendedor -->
<span class="menu-section">Revendedor</span>
<a href="revendedores.php" class="menu-item p-3 rounded-xl"><i class="fa-solid fa-user-tie mr-2"></i> Revendedores</a>
</nav>
    
</aside>

<!-- WHATSAPP -->
<a id="whatsappBtn" href="https://wa.me/message/SGFGII4TEMQFG1" target="_blank">
    <i class="fa-brands fa-whatsapp"></i>
</a>

<script>
const btnMenu = document.getElementById("btnMenu");
const btnCloseMain = document.getElementById("btnCloseMain");
const closeMenu = document.getElementById("closeMenu");
const menu = document.getElementById("menuLateral");
const overlay = document.getElementById("overlay");
const toggleTheme = document.getElementById("toggleTheme");

function abrirMenu() {
    menu.classList.remove("-translate-x-full");
    overlay.classList.remove("opacity-0", "pointer-events-none");
    btnMenu.classList.add("hidden");
    btnCloseMain.classList.remove("hidden");
}

function fecharMenu() {
    menu.classList.add("-translate-x-full");
    overlay.classList.add("opacity-0", "pointer-events-none");
    btnMenu.classList.remove("hidden");
    btnCloseMain.classList.add("hidden");
}

btnMenu.onclick = abrirMenu;
btnCloseMain.onclick = fecharMenu;
closeMenu.onclick = fecharMenu;
overlay.onclick = fecharMenu;

// Tema dark/light
if (localStorage.getItem("theme") === "dark") {
    document.documentElement.classList.add("dark");
}

toggleTheme.onclick = () => {
    document.documentElement.classList.toggle("dark");
    localStorage.setItem("theme", document.documentElement.classList.contains("dark") ? "dark" : "light");
};
</script>