<?php
include('includes/header.php');

// ID do parceiro logado (simulação)
$parceiro_logado = "696dc4ee16e74";

// Lê JSON de clientes
$clientesJson = __DIR__ . '/data/clientes.json';
if(!file_exists($clientesJson)){
    die("JSON de clientes não encontrado!");
}
$clientesData = json_decode(file_get_contents($clientesJson), true);

// Filtra apenas clientes do parceiro logado
$clientes = array_filter($clientesData, fn($c)=>$c['id_parceiro']==$parceiro_logado);

// Lê JSON de parceiros
$parceirosJson = __DIR__ . '/data/parceiros.json';
$parceirosData = json_decode(file_get_contents($parceirosJson), true);
$parceiro = array_filter($parceirosData, fn($p)=>$p['id']==$parceiro_logado);
$parceiro = array_values($parceiro)[0] ?? null;

// Link da loja automático
$host = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://".$_SERVER['HTTP_HOST'];
$lojaLink = $host."/loja.php?id=".$parceiro_logado;
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<main class="pt-24 px-4 sm:px-6 lg:px-8 max-w-7xl mx-auto">

    <!-- Link do catálogo -->
    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:gap-2">
        <input type="text" id="linkCatalogoGeral" 
            value="<?= $lojaLink ?>" readonly
            class="flex-1 bg-[var(--body-bg)] dark:bg-[var(--body-bg)] text-[var(--text-primary)] rounded px-4 py-2 border border-[var(--border-color)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" />
        <button onclick="copiarLinkGeral()"
            class="mt-2 sm:mt-0 bg-[var(--accent)] text-white px-6 py-2 rounded shadow hover:bg-[var(--accent)]/90 flex items-center gap-2">
            <i class="fa-solid fa-copy"></i> Copiar
        </button>
    </div>

    <!-- Indicadores -->
    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mb-6">
        <div class="bg-[var(--menu-secondary)] dark:bg-[var(--menu-secondary)] shadow rounded p-4 flex items-center gap-3 border border-[var(--border-color)]">
            <i class="fa-solid fa-users text-3xl text-[var(--accent)]"></i>
            <div>
                <h3 class="text-sm font-semibold text-[var(--text-secondary)]">Total Clientes</h3>
                <p class="mt-1 text-2xl font-bold text-[var(--text-primary)]"><?= count($clientes) ?></p>
            </div>
        </div>
        <div class="bg-[var(--menu-secondary)] dark:bg-[var(--menu-secondary)] shadow rounded p-4 flex items-center gap-3 border border-[var(--border-color)]">
            <i class="fa-solid fa-user-check text-3xl text-green-600"></i>
            <div>
                <h3 class="text-sm font-semibold text-[var(--text-secondary)]">Ativos</h3>
                <p class="mt-1 text-2xl font-bold text-[var(--text-primary)]">
                    <?= count(array_filter($clientes, fn($c)=>$c['status']=='ativo')) ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Busca e botão adicionar -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:gap-4 mb-6">
        <input type="text" id="buscaCliente" placeholder="Buscar por nome ou email"
            class="flex-1 bg-[var(--body-bg)] dark:bg-[var(--body-bg)] text-[var(--text-primary)] rounded px-4 py-2 border border-[var(--border-color)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)] mb-2 sm:mb-0" />
        <a href="adicionar_cliente.php"
            class="bg-[var(--accent)] text-white px-6 py-2 rounded shadow hover:bg-[var(--accent)]/90 w-full sm:w-auto text-center flex items-center justify-center gap-2">
            <i class="fa-solid fa-plus"></i> Adicionar Cliente
        </a>
    </div>

    <!-- Lista de clientes -->
    <div id="listaClientes" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <?php foreach($clientes as $cliente): ?>
        <div class="bg-[var(--menu-secondary)] dark:bg-[var(--menu-secondary)] shadow rounded p-4 flex flex-col border border-[var(--border-color)] relative">
            
            <!-- Botão deletar -->
            <button onclick="excluirCliente('<?= $cliente['id'] ?>')"
                class="absolute top-2 right-2 text-red-500 hover:text-red-700">
                <i class="fa-solid fa-trash"></i>
            </button>

            <h3 class="text-lg font-semibold text-[var(--text-primary)]"><?= $cliente['nome'] ?></h3>
            <p class="text-sm text-[var(--text-secondary)] mb-1"><?= $cliente['email'] ?></p>
            <p class="text-sm text-[var(--text-secondary)]">ID: <?= $cliente['id'] ?></p>
            <p class="text-sm text-[var(--text-secondary)]">Saldo: R$ <?= number_format($cliente['saldo'],2,",",".") ?></p>
            <p class="text-sm mb-2 <?= $cliente['status']=='ativo'?'text-green-600':'text-yellow-600' ?>">Status: <?= strtoupper($cliente['status']) ?></p>
            
            <!-- Botões na mesma linha -->
            <div class="mt-auto flex flex-col sm:flex-row gap-2">
                <a href="editar_cliente.php?id=<?= $cliente['id'] ?>"
                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-center flex items-center justify-center gap-2">
                    <i class="fa-solid fa-pen"></i> Editar
                </a>
                <a href="https://wa.me/<?= $cliente['whatsapp'] ?>" target="_blank"
                    class="flex-1 bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded text-center flex items-center justify-center gap-2">
                    <i class="fa-brands fa-whatsapp"></i> WhatsApp
                </a>
                <a href="visualizar_cliente.php?id=<?= $cliente['id'] ?>"
                    class="flex-1 bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded text-center flex items-center justify-center gap-2">
                    <i class="fa-solid fa-eye"></i> Visualizar
                </a>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

</main>

<script>
// Copiar link da loja
function copiarLinkGeral() {
    const input = document.getElementById('linkCatalogoGeral');
    input.select();
    input.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(input.value).then(() => {
        Swal.fire({
            icon: 'success',
            title: 'Link copiado!',
            toast: true,
            position: 'top-end',
            timer: 2000,
            showConfirmButton: false
        });
    });
}

// Excluir cliente com SweetAlert2
function excluirCliente(id){
    Swal.fire({
        title: 'Tem certeza?',
        text: "O cliente será excluído!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sim, excluir!'
    }).then((result) => {
        if (result.isConfirmed) {
            // Aqui você pode fazer request AJAX para excluir
            Swal.fire('Excluído!', 'O cliente foi removido.', 'success');
        }
    });
}

// Busca de clientes
document.getElementById('buscaCliente').addEventListener('input', function(){
    const filtro = this.value.toLowerCase();
    document.querySelectorAll('#listaClientes > div').forEach(card=>{
        const nome = card.querySelector('h3').innerText.toLowerCase();
        const email = card.querySelector('p').innerText.toLowerCase();
        if(nome.includes(filtro) || email.includes(filtro)){
            card.style.display = 'flex';
        }else{
            card.style.display = 'none';
        }
    });
});
</script>