<?php
/**
 * Página de Perfil do Cliente - conta.php (Versão Dashboard Premium com Abas)
 * CORREÇÃO V2: Sincronização de saldo garantida e layout de cards ajustado.
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
date_default_timezone_set('America/Sao_Paulo');

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$clientes_file  = $base_path . 'clientes.json';
$recargas_file  = $base_path . 'recargas.json';

function load_json($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) ?: [] : [];
}

function save_json($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$parceiros = load_json($parceiros_file);
$parceiro = null;
foreach($parceiros as $p){
    if((string)($p['id'] ?? '') === $idParceiro){
        $parceiro = $p;
        break;
    }
}

if(!$parceiro) {
    ?>
    <!DOCTYPE html>
    <html lang="pt-br">
    <head>
        <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Loja não encontrada</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
        <style>body { font-family: 'Inter', sans-serif; }</style>
    </head>
    <body class="bg-[#f8fafc] h-screen flex items-center justify-center p-6">
        <div class="text-center max-w-md w-full bg-white p-10 rounded-[24px] shadow-xl border border-slate-100">
            <div class="w-20 h-20 bg-red-50 text-red-500 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fa-solid fa-store-slash text-3xl"></i>
            </div>
            <h1 class="text-2xl font-black text-slate-900 mb-2">Loja não encontrada</h1>
            <p class="text-slate-500 mb-8 text-sm">O link acessado é inválido ou a loja não está disponível.</p>
            <a href="index.php" class="block w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-sm hover:bg-slate-800 transition-all">Voltar ao Início</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $clientes = load_json($clientes_file);

    if ($_POST['action'] === 'editar_perfil') {
        $idCliente = $_POST['id_cliente'] ?? '';
        $success = false;
        foreach ($clientes as &$c) {
            if ($c['id'] === $idCliente) {
                $c['nome'] = $_POST['nome'] ?? $c['nome'];
                $c['email'] = $_POST['email'] ?? $c['email'];
                $c['whatsapp'] = $_POST['whatsapp'] ?? $c['whatsapp'];
                if (!empty($_POST['senha'])) {
                    $c['senha'] = $_POST['senha'];
                }
                $success = true;
                $updatedUser = $c;
                break;
            }
        }
        if ($success) {
            save_json($clientes_file, $clientes);
            echo json_encode(['success' => true, 'user' => $updatedUser]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Usuário não encontrado.']);
        }
        exit;
    }

    if ($_POST['action'] === 'recarga_pix') {
        $amount = (float)($_POST['amount'] ?? 0);
        $token = $parceiro['token'] ?? '';
        $idCliente = $_POST['id_cliente'] ?? '';
        
        if ($amount < 1) {
            echo json_encode(['success' => false, 'message' => 'Valor mínimo de R$ 1,00']);
            exit;
        }

        $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
        $webhookUrl = "$protocol://{$_SERVER['HTTP_HOST']}/webhook_recarga.php";

        $ch = curl_init('https://api.pushinpay.com.br/api/pix/cashIn');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
            "value" => (int)($amount * 100),
            "webhook_url" => $webhookUrl,
            "external_id" => "recarga_".$idCliente."_".uniqid()
        ]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $token,
            'Accept: application/json',
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = json_decode(curl_exec($ch), true);
        curl_close($ch);

        if (isset($res['id'])) {
            $recargas = load_json($recargas_file);
            $recargaId = "rec_" . uniqid();
            $novaRecarga = [
                "id" => $recargaId,
                "id_parceiro" => $idParceiro,
                "id_cliente" => $idCliente,
                "valor" => $amount,
                "status_pagamento" => "pendente",
                "creditado" => false, // Novo campo para controle de saldo
                "transaction_id" => $res['id'],
                "data" => date('c')
            ];
            $recargas[] = $novaRecarga;
            save_json($recargas_file, $recargas);
            
            echo json_encode([
                'success' => true, 
                'transaction_id' => $res['id'],
                'qr_code' => $res['qr_code'] ?? '',
                'qr_code_base64' => $res['qr_code_base64'] ?? ''
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao gerar PIX.']);
        }
        exit;
    }

    if ($_POST['action'] === 'listar_recargas') {
        $idCliente = $_POST['id_cliente'] ?? '';
        $recargas = load_json($recargas_file);
        $minhasRecargas = array_filter($recargas, function($r) use ($idCliente) {
            return $r['id_cliente'] === $idCliente;
        });
        usort($minhasRecargas, function($a, $b) {
            return strtotime($b['data']) - strtotime($a['data']);
        });
        echo json_encode(['recargas' => array_values($minhasRecargas)]);
        exit;
    }

    if ($_POST['action'] === 'verificar_status_recarga') {
        $transactionId = $_POST['transaction_id'] ?? '';
        $idCliente = $_POST['id_cliente'] ?? '';
        $recargas = load_json($recargas_file);
        $clientes = load_json($clientes_file);
        $mudou = false;

        foreach ($recargas as &$r) {
            if (($r['transaction_id'] ?? '') === $transactionId && $r['id_cliente'] === $idCliente) {
                
                // Se já estiver pago mas não creditado (ex: alteração manual no JSON)
                if ($r['status_pagamento'] === 'pago' && !($r['creditado'] ?? false)) {
                    foreach ($clientes as &$c) {
                        if ($c['id'] === $idCliente) {
                            $c['saldo'] = (float)$c['saldo'] + (float)$r['valor'];
                            $r['creditado'] = true;
                            $mudou = true;
                            break;
                        }
                    }
                } 
                // Se ainda estiver pendente, consulta a API
                else if ($r['status_pagamento'] === 'pendente') {
                    $ch = curl_init('https://api.pushinpay.com.br/api/transactions/' . $transactionId);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . ($parceiro['token'] ?? ''), 'Accept: application/json']);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $res = json_decode(curl_exec($ch), true);
                    curl_close($ch);
                    
                    if (isset($res['status']) && ($res['status'] === 'paid' || $res['status'] === 'approved')) {
                        $r['status_pagamento'] = 'pago';
                        $r['pago_em'] = date('c');
                        foreach ($clientes as &$c) {
                            if ($c['id'] === $idCliente) {
                                $c['saldo'] = (float)$c['saldo'] + (float)$r['valor'];
                                $r['creditado'] = true;
                                $mudou = true;
                                break;
                            }
                        }
                    }
                }

                if ($mudou) {
                    save_json($recargas_file, $recargas);
                    save_json($clientes_file, $clientes);
                    
                    // Busca o usuário atualizado para retornar ao frontend
                    $userUpdated = null;
                    foreach($clientes as $cu) { if($cu['id'] === $idCliente) { $userUpdated = $cu; break; } }
                    
                    echo json_encode(['status' => 'pago', 'user' => $userUpdated]);
                    exit;
                }

                echo json_encode(['status' => $r['status_pagamento']]);
                exit;
            }
        }
        echo json_encode(['status' => 'nao_encontrado']);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Minha Conta | <?= htmlspecialchars($parceiro['nome']) ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; font-family: 'Inter', sans-serif; }
        
        .tab-btn { padding: 12px 24px; font-size: 12px; font-weight: 800; text-transform: uppercase; letter-spacing: 0.1em; border-bottom: 3px solid transparent; transition: all 0.2s; color: #94a3b8; }
        .tab-btn.active { color: var(--p-color); border-bottom-color: var(--p-color); }

        .card { background: #fff; border-radius: 16px; border: 1px solid #e2e8f0; padding: 24px; transition: all 0.2s; }
        .card:hover { border-color: var(--p-color); box-shadow: 0 10px 25px -5px rgb(0 0 0 / 0.05); }
        
        .balance-card { background: linear-gradient(135deg, #1e1b4b 0%, #312e81 100%); color: white; border-radius: 20px; padding: 28px; position: relative; overflow: hidden; box-shadow: 0 20px 40px -10px rgba(0,0,0,0.3); border: 1px solid rgba(255,255,255,0.1); }
        .balance-card::before { content: ''; position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: radial-gradient(circle at top right, rgba(255,255,255,0.1), transparent); border-radius: 20px; }
        .balance-card::after { content: ''; position: absolute; top: -50%; right: -20%; width: 200px; height: 200px; background: rgba(255,255,255,0.05); border-radius: 50%; }
        
        .input-field { width: 100%; padding: 12px 16px; border-radius: 12px; border: 1px solid #e2e8f0; outline: none; transition: all 0.2s; font-size: 14px; font-weight: 500; }
        .input-field:focus { border-color: var(--p-color); box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.1); }
        .label-field { display: block; font-size: 10px; font-weight: 800; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.1em; margin-bottom: 8px; margin-left: 4px; }
        
        .btn-primary { background: var(--p-color); color: white; padding: 12px 24px; border-radius: 12px; font-weight: 800; font-size: 11px; text-transform: uppercase; letter-spacing: 0.15em; border: none; cursor: pointer; transition: all 0.2s; }
        .btn-primary:hover { opacity: 0.9; transform: translateY(-1px); box-shadow: 0 8px 20px -5px rgba(37, 99, 235, 0.3); }

        .copy-box { background: #f8fafc; padding: 16px; border-radius: 8px; font-family: monospace; font-size: 12px; word-break: break-all; margin: 16px 0; border: 1px dashed #cbd5e1; color: #475569; }

        .amount-input-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin: 24px auto 16px;
            width: 100%;
        }

        .amount-label {
            font-size: 22px;
            font-weight: 900;
            color: #1e293b;
        }

        .amount-input-wrapper input {
            width: 100%;
            max-width: 240px;
            min-width: 140px;
            font-size: 30px;
            font-weight: 900;
            text-align: center;
            padding: 16px 12px;
            border: 2px solid #e2e8f0;
            border-radius: 6px;
            outline: none;
            transition: all 0.2s;
        }

        .amount-input-wrapper input:focus {
            border-color: var(--p-color);
            box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.15);
        }

        .recarga-overlay { position: fixed; inset: 0; background: rgba(0,0,0,0.5); display: none; align-items: center; justify-content: center; z-index: 50; }
        .recarga-overlay.active { display: flex; }
        .recarga-container {
            background: white;
            border-radius: 8px;
            padding: 32px;
            width: 100%;
            max-width: 420px;
            min-width: 280px;
            margin: 0 16px;
            box-shadow: 0 20px 60px -10px rgba(0,0,0,0.3);
        }

        .status-badge { padding: 6px 12px; border-radius: 8px; font-size: 10px; font-weight: 800; text-transform: uppercase; display: inline-flex; align-items: center; gap: 6px; }
        .status-pago { background: #dcfce7; color: #166534; border: 1px solid #bbf7d0; }
        .status-pendente { background: #fef9c3; color: #854d0e; border: 1px solid #fef08a; }
        .status-cancelado { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }

        /* CORREÇÃO: Espaçamento entre cards de registros */
        #registrosList {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }

        #registrosList .card {
            margin: 0;
        }

        @media (max-width: 768px) {
            #registrosList {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 640px) {
            .card { padding: 20px; }
            .balance-card { padding: 24px; }
            .tab-btn { padding: 12px 16px; font-size: 10px; }
            .amount-input-wrapper input {
                max-width: 200px;
                font-size: 26px;
                padding: 14px 10px;
            }
            .recarga-container { padding: 24px; }
        }
    </style>
</head>
<body>

<?php include 'includes/menu.php'; ?>

<main class="max-w-5xl mx-auto px-4 py-8 lg:py-12">
    <div class="mb-8">
        <div class="flex items-center gap-3 mb-2">
            <div class="w-2 h-8 bg-primary rounded-full"></div>
            <h1 class="text-3xl font-black text-slate-900 tracking-tight">Olá, <span id="clientName">Cliente</span>!</h1>
        </div>
        <p class="text-slate-500 text-sm ml-5">Gerencie sua conta e informações pessoais.</p>
    </div>

    <div class="flex border-b border-slate-200 mb-8 overflow-x-auto">
        <button onclick="switchTab('carteira')" id="tabCarteira" class="tab-btn active">
            <i class="ph ph-wallet mr-2"></i> Carteira
        </button>
        <button onclick="switchTab('registros')" id="tabRegistros" class="tab-btn">
            <i class="ph ph-receipt mr-2"></i> Registros
        </button>
        <button onclick="switchTab('perfil')" id="tabPerfil" class="tab-btn">
            <i class="ph ph-user-circle mr-2"></i> Perfil
        </button>
    </div>

    <div id="contentCarteira" class="space-y-6">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div class="lg:col-span-1 space-y-6">
                <div class="balance-card">
                    <div class="relative z-10 flex flex-col h-full justify-between">
                        <div>
                            <p class="text-white/60 text-[9px] font-bold uppercase tracking-[0.3em] mb-8">Saldo Premium</p>
                            <h2 class="text-5xl font-black tracking-tighter mb-2" id="userBalance">R$ 0,00</h2>
                            <p class="text-white/40 text-[10px] uppercase tracking-[0.15em]">Saldo Disponível para Compras na Loja</p>
                        </div>
                        <div class="mt-8 pt-6 border-t border-white/10">
                            <p class="text-white/50 text-[8px] font-bold uppercase tracking-[0.2em] mb-2">Titular do Cartão</p>
                            <p class="text-white font-black text-[13px] tracking-wider" id="cardName">CLIENTE</p>
                        </div>
                        <button onclick="showRecargaForm()" class="w-full bg-white text-indigo-900 py-3.5 rounded-xl font-black text-[11px] uppercase tracking-widest hover:bg-slate-50 transition-all flex items-center justify-center gap-2 shadow-lg mt-6">
                            <i class="ph-bold ph-plus-circle text-lg"></i> Adicionar Saldo
                        </button>
                    </div>
                </div>

                <div class="card">
                    <h3 class="text-[10px] font-black text-slate-900 uppercase tracking-widest mb-5 flex items-center gap-2">
                        <i class="ph-bold ph-lightning text-amber-500"></i> Atalhos Rápidos
                    </h3>
                    <div class="space-y-2">
                        <a href="meus-pedidos.php?id=<?= $idParceiro ?>" class="flex items-center justify-between p-3.5 rounded-xl hover:bg-slate-50 transition-all border border-slate-100 group">
                            <div class="flex items-center gap-3">
                                <div class="w-9 h-9 bg-blue-50 text-blue-600 rounded-lg flex items-center justify-center">
                                    <i class="ph-bold ph-download-simple text-lg"></i>
                                </div>
                                <span class="text-xs font-bold text-slate-600">Meus Downloads</span>
                            </div>
                            <i class="ph-bold ph-caret-right text-slate-300 group-hover:text-slate-400"></i>
                        </a>
                        <a href="favoritos.php?id=<?= $idParceiro ?>" class="flex items-center justify-between p-3.5 rounded-xl hover:bg-slate-50 transition-all border border-slate-100 group">
                            <div class="flex items-center gap-3">
                                <div class="w-9 h-9 bg-red-50 text-red-600 rounded-lg flex items-center justify-center">
                                    <i class="ph-bold ph-heart text-lg"></i>
                                </div>
                                <span class="text-xs font-bold text-slate-600">Meus Favoritos</span>
                            </div>
                            <i class="ph-bold ph-caret-right text-slate-300 group-hover:text-slate-400"></i>
                        </a>
                        <a href="meus-pedidos.php?id=<?= $idParceiro ?>&tab=pagamentos" class="flex items-center justify-between p-3.5 rounded-xl hover:bg-slate-50 transition-all border border-slate-100 group">
                            <div class="flex items-center gap-3">
                                <div class="w-9 h-9 bg-green-50 text-green-600 rounded-lg flex items-center justify-center">
                                    <i class="ph-bold ph-receipt text-lg"></i>
                                </div>
                                <span class="text-xs font-bold text-slate-600">Histórico de Pagamentos</span>
                            </div>
                            <i class="ph-bold ph-caret-right text-slate-300 group-hover:text-slate-400"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="lg:col-span-2">
                <div class="card h-full flex items-center justify-center text-center">
                    <div class="max-w-sm">
                        <div class="w-16 h-16 bg-slate-50 text-slate-400 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="ph-bold ph-credit-card text-3xl"></i>
                        </div>
                        <h3 class="text-lg font-black text-slate-900 mb-1">Sua Carteira Digital</h3>
                        <p class="text-slate-500 text-sm">Utilize seu saldo para compras rápidas e seguras na loja.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="contentRegistros" class="hidden">
        <div id="registrosList"></div>
    </div>

    <div id="contentPerfil" class="hidden space-y-6">
        <div class="card shadow-sm">
            <div class="flex items-center gap-4 mb-8 pb-6 border-b border-slate-100">
                <div class="w-12 h-12 bg-slate-50 text-slate-900 rounded-xl flex items-center justify-center text-xl border border-slate-100">
                    <i class="ph-bold ph-user-circle"></i>
                </div>
                <div>
                    <h3 class="text-lg font-black text-slate-900 tracking-tight">Informações do Perfil</h3>
                    <p class="text-slate-400 text-[9px] font-bold uppercase tracking-[0.15em]">Mantenha seus dados e senha atualizados</p>
                </div>
            </div>

            <form id="profileForm" class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="label-field">Nome Completo</label>
                        <input type="text" name="nome" id="userNameInput" class="input-field" placeholder="Seu nome">
                    </div>
                    <div>
                        <label class="label-field">WhatsApp</label>
                        <input type="text" name="whatsapp" id="userWhatsapp" class="input-field" placeholder="(00) 00000-0000">
                    </div>
                </div>
                <div>
                    <label class="label-field">E-mail de Acesso</label>
                    <input type="email" name="email" id="userEmail" class="input-field" placeholder="seu@email.com">
                </div>
                <div class="pt-4 border-t border-slate-100">
                    <label class="label-field">Nova Senha (deixe em branco para manter)</label>
                    <div class="relative">
                        <input type="password" name="senha" class="input-field pr-12" placeholder="••••••••">
                        <div class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-300">
                            <i class="ph-bold ph-lock-key text-lg"></i>
                        </div>
                    </div>
                </div>
                <div class="flex justify-end pt-2">
                    <button type="submit" class="btn-primary w-full shadow-lg shadow-primary/20">
                        <i class="ph-bold ph-check-circle text-lg"></i> Salvar Alterações
                    </button>
                </div>
            </form>
        </div>
    </div>
</main>

<!-- Overlay de Recarga (Tela Cheia) -->
<div id="recargaOverlay" class="recarga-overlay">
    <div id="recargaForm" class="recarga-container">
        <div class="flex items-center justify-between mb-6 pb-4 border-b border-slate-100">
            <h3 class="text-lg font-black text-slate-900">Recarregar Saldo</h3>
            <button onclick="hideRecargaForm()" class="text-slate-400 hover:text-slate-600 transition-colors">
                <i class="ph-bold ph-x text-2xl"></i>
            </button>
        </div>

        <form id="recargaFormElement" class="space-y-6">
            <div>
                <label class="label-field">Quanto você deseja adicionar?</label>
                <div class="amount-input-wrapper">
                    <span class="amount-label">R$</span>
                    <input type="number" id="amountInput" name="amount" min="1" step="1" value="10" placeholder="0" required>
                </div>
                <p class="text-[10px] text-slate-400 uppercase tracking-widest font-bold">Mínimo R$ 1,00</p>
            </div>

            <div class="pt-4 border-t border-slate-100">
                <button type="submit" class="btn-primary w-full">
                    <i class="ph-bold ph-check-circle text-lg"></i> Gerar Pix
                </button>
            </div>
        </form>
    </div>

    <div id="pixModal" class="hidden recarga-container">
        <div class="flex items-center justify-between mb-6 pb-4 border-b border-slate-100">
            <h3 class="text-lg font-black text-slate-900">Pagamento Pix</h3>
            <button onclick="cancelarPix()" class="text-slate-400 hover:text-slate-600 transition-colors">
                <i class="ph-bold ph-x text-2xl"></i>
            </button>
        </div>

        <div class="space-y-6">
            <div class="text-center">
                <p class="text-slate-600 text-sm mb-4">Escaneie o QR Code ou copie o código Pix</p>
                <div class="bg-white p-4 rounded-md border border-slate-100 inline-block shadow-sm">
                    <img id="qrCodeImg" src="" class="w-48 h-48">
                </div>
            </div>

            <div class="copy-box text-[11px] rounded-md" id="pixCode">Carregando...</div>

            <button type="button" onclick="copiarPix()" class="btn-primary w-full rounded-md">
                <i class="ph-bold ph-copy text-lg"></i> Copiar Código Pix
            </button>
            <button type="button" onclick="cancelarPix()" class="text-[9px] font-bold text-slate-400 uppercase py-2 hover:text-slate-600 transition-colors w-full">Voltar para a Loja</button>
        </div>
    </div>
</div>

<script>
    const idParceiro = '<?= $idParceiro ?>';
    let user = JSON.parse(localStorage.getItem('user_' + idParceiro));
    let pixPollingTimer = null;

    if (!user) { window.location.href = 'carrinho.php?id=' + idParceiro; }

    function switchTab(tab) {
        document.getElementById('tabCarteira').classList.toggle('active', tab === 'carteira');
        document.getElementById('tabRegistros').classList.toggle('active', tab === 'registros');
        document.getElementById('tabPerfil').classList.toggle('active', tab === 'perfil');
        document.getElementById('contentCarteira').classList.toggle('hidden', tab !== 'carteira');
        document.getElementById('contentRegistros').classList.toggle('hidden', tab !== 'registros');
        document.getElementById('contentPerfil').classList.toggle('hidden', tab !== 'perfil');
        if (tab === 'registros') renderRegistros();
    }

    function showRecargaForm() {
        document.getElementById('recargaOverlay').classList.add('active');
        document.getElementById('recargaForm').classList.remove('hidden');
        document.getElementById('pixModal').classList.add('hidden');
        setTimeout(() => document.getElementById('amountInput').focus(), 100);
    }

    function hideRecargaForm() {
        document.getElementById('recargaOverlay').classList.remove('active');
        document.getElementById('recargaForm').classList.remove('hidden');
        document.getElementById('pixModal').classList.add('hidden');
    }

    function cancelarPix() {
        if (pixPollingTimer) clearInterval(pixPollingTimer);
        hideRecargaForm();
    }

    async function renderRegistros() {
        const fd = new FormData();
        fd.append('action', 'listar_recargas');
        fd.append('id_cliente', user.id);
        const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
        const recargas = res.recargas || [];
        const container = document.getElementById('registrosList');
        
        if (!recargas.length) {
            container.innerHTML = '<div class="py-24 text-center col-span-full"><p class="text-slate-600">Nenhuma recarga realizada</p></div>';
            return;
        }

        container.innerHTML = recargas.map(r => {
            const data = new Date(r.data);
            const dataFormatada = data.toLocaleDateString('pt-BR', {day:'2-digit', month:'long', year:'numeric'});
            const hora = data.toLocaleTimeString('pt-BR', {hour:'2-digit', minute:'2-digit'});
            
            let statusClass = 'status-pendente';
            let statusText = 'Aguardando';
            if (r.status_pagamento === 'pago') { statusClass = 'status-pago'; statusText = 'Aprovado'; }
            else if (r.status_pagamento === 'cancelado') { statusClass = 'status-cancelado'; statusText = 'Cancelado'; }
            
            return `
                <div class="card">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] mb-1">Recarga #${r.id}</p>
                            <p class="text-sm font-bold text-slate-900">${dataFormatada} às ${hora}</p>
                        </div>
                        <span class="status-badge status-${r.status_pagamento}">${statusText}</span>
                    </div>
                    <div class="flex justify-between items-center pt-4 border-t border-slate-100">
                        <div class="flex items-center gap-2 text-slate-400">
                            <i class="ph ph-credit-card text-lg"></i>
                            <span class="text-[10px] font-bold uppercase tracking-widest">Pix</span>
                        </div>
                        <span class="text-lg font-black text-slate-900">R$ ${parseFloat(r.valor).toLocaleString('pt-BR', {minimumFractionDigits:2})}</span>
                    </div>
                </div>
            `;
        }).join('');
    }

    function init() {
        document.getElementById('userNameInput').value = user.nome;
        document.getElementById('userEmail').value = user.email;
        document.getElementById('userWhatsapp').value = user.whatsapp || '';
        document.getElementById('clientName').innerText = user.nome.split(' ')[0];
        document.getElementById('cardName').innerText = user.nome.toUpperCase();
        document.getElementById('userBalance').innerText = `R$ ${parseFloat(user.saldo).toLocaleString('pt-BR', {minimumFractionDigits: 2})}`;
        switchTab('carteira');
    }

    document.getElementById('profileForm').onsubmit = async (e) => {
        e.preventDefault();
        const formData = new FormData(e.target);
        formData.append('action', 'editar_perfil');
        formData.append('id_cliente', user.id);
        Swal.fire({ title: 'Salvando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
        const res = await (await fetch(window.location.href, { method: 'POST', body: formData })).json();
        if (res.success) {
            localStorage.setItem('user_' + idParceiro, JSON.stringify(res.user));
            user = res.user;
            Swal.fire({ title: 'Sucesso!', text: 'Perfil atualizado com sucesso.', icon: 'success', timer: 2000, showConfirmButton: false });
            init();
        } else { Swal.fire('Erro', res.message, 'error'); }
    };

    document.getElementById('recargaFormElement').onsubmit = async (e) => {
        e.preventDefault();
        const amount = parseFloat(document.getElementById('amountInput').value);
        
        if (amount < 1) {
            Swal.fire('Erro', 'Valor mínimo é R$ 1,00', 'error');
            return;
        }

        const fd = new FormData();
        fd.append('action', 'recarga_pix');
        fd.append('amount', amount);
        fd.append('id_cliente', user.id);
        
        Swal.fire({ title: 'Gerando Pix...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
        const res = await (await fetch(window.location.href, {method:'POST', body:fd})).json();
        Swal.close();
        
        if(res.success) {
            document.getElementById('qrCodeImg').src = res.qr_code_base64;
            document.getElementById('pixCode').innerText = res.qr_code;
            document.getElementById('recargaForm').classList.add('hidden');
            document.getElementById('pixModal').classList.remove('hidden');

            if (pixPollingTimer) clearInterval(pixPollingTimer);
            
            pixPollingTimer = setInterval(async () => {
                const fd2 = new FormData();
                fd2.append('action', 'verificar_status_recarga');
                fd2.append('transaction_id', res.transaction_id);
                fd2.append('id_cliente', user.id);
                
                const st = await (await fetch(window.location.href, {method:'POST', body: fd2})).json();
                if(st.status === 'pago') {
                    clearInterval(pixPollingTimer);
                    
                    // Atualiza o usuário com os dados vindos do servidor (saldo atualizado)
                    if (st.user) {
                        user = st.user;
                        localStorage.setItem('user_' + idParceiro, JSON.stringify(user));
                    }
                    
                    Swal.fire({
                        title:'Pago!', 
                        text:'Seu saldo foi atualizado com sucesso. Novo saldo: R$ ' + parseFloat(user.saldo).toLocaleString('pt-BR', {minimumFractionDigits:2}), 
                        icon:'success', 
                        timer:3000, 
                        showConfirmButton:false
                    }).then(()=> {
                        hideRecargaForm();
                        init();
                    });
                }
            }, 3000);
        } else { 
            Swal.fire({title:'Erro', text:res.message, icon:'error'}); 
        }
    };

    function copiarPix() {
        const code = document.getElementById('pixCode').innerText;
        navigator.clipboard.writeText(code).then(() => {
            const btn = event.target.closest('button');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="ph-bold ph-check-circle"></i> COPIADO!';
            btn.classList.replace('bg-primary', 'bg-green-500');
            setTimeout(() => { 
                btn.innerHTML = originalText; 
                btn.classList.replace('bg-green-500', 'bg-primary');
            }, 2000);
        });
    }

    init();
</script>
</body>
</html>
