<?php
/**
 * Página de Favoritos do Cliente - favoritos.php (Versão Dashboard Premium)
 * Layout IDÊNTICO ao Meus Pedidos/Conta | Estrutura de Duas Colunas | Grid de Produtos
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
date_default_timezone_set('America/Sao_Paulo');

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$produtos_file  = $base_path . 'produtos.json';

function load_json($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) ?: [] : [];
}

$parceiros = load_json($parceiros_file);
$produtos = load_json($produtos_file);

$parceiro = null;
foreach($parceiros as $p){
    if((string)($p['id'] ?? '') === $idParceiro){
        $parceiro = $p;
        break;
    }
}

if(!$parceiro) {
    ?>
    <!DOCTYPE html>
    <html lang="pt-br">
    <head>
        <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Loja não encontrada</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
        <style>body { font-family: 'Inter', sans-serif; }</style>
    </head>
    <body class="bg-[#f8fafc] h-screen flex items-center justify-center p-6">
        <div class="text-center max-w-md w-full bg-white p-10 rounded-[24px] shadow-xl border border-slate-100">
            <div class="w-20 h-20 bg-red-50 text-red-500 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fa-solid fa-store-slash text-3xl"></i>
            </div>
            <h1 class="text-2xl font-black text-slate-900 mb-2">Loja não encontrada</h1>
            <p class="text-slate-500 mb-8 text-sm">O link acessado é inválido ou a loja não está disponível.</p>
            <a href="index.php" class="block w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-sm hover:bg-slate-800 transition-all">Voltar ao Início</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Meus Favoritos | <?= htmlspecialchars($parceiro['nome']) ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; font-family: 'Inter', sans-serif; }
        
        .card { background: #fff; border-radius: 16px; border: 1px solid #e2e8f0; padding: 24px; transition: all 0.2s; }
        .card:hover { border-color: var(--p-color); box-shadow: 0 10px 25px -5px rgb(0 0 0 / 0.05); }
        
        .product-card { background: #fff; border-radius: 16px; border: 1px solid #e2e8f0; overflow: hidden; transition: all 0.3s; display: flex; flex-direction: column; height: 100%; }
        .product-card:hover { border-color: var(--p-color); box-shadow: 0 10px 25px -5px rgb(0 0 0 / 0.1); transform: translateY(-2px); }
        .product-image { width: 100%; height: 200px; background: #f8fafc; display: flex; align-items: center; justify-content: center; overflow: hidden; border-bottom: 1px solid #f1f5f9; }
        .product-image img { width: 100%; height: 100%; object-fit: contain; padding: 12px; }
        
        .btn-primary { background-color: var(--p-color); color: #fff; padding: 10px 16px; border-radius: 8px; font-weight: 800; font-size: 11px; text-transform: uppercase; letter-spacing: 0.05em; transition: all 0.2s; display: inline-flex; align-items: center; justify-content: center; gap: 6px; border: none; cursor: pointer; }
        .btn-primary:hover { opacity: 0.9; transform: translateY(-1px); box-shadow: 0 8px 20px -5px rgba(var(--p-color), 0.3); }
        
        .btn-secondary { background-color: #f1f5f9; color: #64748b; padding: 10px 16px; border-radius: 8px; font-weight: 800; font-size: 11px; text-transform: uppercase; letter-spacing: 0.05em; transition: all 0.2s; display: inline-flex; align-items: center; justify-content: center; gap: 6px; border: 1px solid #e2e8f0; cursor: pointer; }
        .btn-secondary:hover { background-color: #e2e8f0; color: #475569; }

        @media (max-width: 640px) { .card { padding: 20px; } }
    </style>
</head>
<body>

<?php include 'includes/menu.php'; ?>

<main class="max-w-5xl mx-auto px-4 py-8 lg:py-12">
    <div class="mb-8">
        <div class="flex items-center gap-3 mb-2">
            <div class="w-2 h-8 bg-primary rounded-full"></div>
            <h1 class="text-3xl font-black text-slate-900 tracking-tight">Meus Favoritos</h1>
        </div>
        <p class="text-slate-500 text-sm ml-5">Seus produtos marcados como favoritos.</p>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <div class="lg:col-span-1 space-y-6">
            <div class="card">
                <h3 class="text-[10px] font-black text-slate-900 uppercase tracking-widest mb-5 flex items-center gap-2">
                    <i class="ph-bold ph-heart text-red-500"></i> Seus Favoritos
                </h3>
                <div class="space-y-3">
                    <div class="flex items-center justify-between p-3.5 rounded-xl bg-slate-50 border border-slate-100">
                        <span class="text-xs font-bold text-slate-600">Total de Favoritos</span>
                        <span class="text-lg font-black text-slate-900" id="totalFavoritos">0</span>
                    </div>
                    <a href="carrinho.php?id=<?= $idParceiro ?>" class="flex items-center justify-between p-3.5 rounded-xl hover:bg-slate-50 transition-all border border-slate-100 group">
                        <div class="flex items-center gap-3">
                            <div class="w-9 h-9 bg-blue-50 text-blue-600 rounded-lg flex items-center justify-center">
                                <i class="ph-bold ph-shopping-cart text-lg"></i>
                            </div>
                            <span class="text-xs font-bold text-slate-600">Ir para Loja</span>
                        </div>
                        <i class="ph-bold ph-caret-right text-slate-300 group-hover:text-slate-400"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="lg:col-span-2">
            <div id="favoritosGrid" class="grid grid-cols-1 sm:grid-cols-2 gap-6"></div>
            <div id="emptyState" class="card h-full flex items-center justify-center text-center hidden">
                <div class="max-w-sm">
                    <div class="w-16 h-16 bg-slate-50 text-slate-400 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="ph-bold ph-heart text-3xl"></i>
                    </div>
                    <h3 class="text-lg font-black text-slate-900 mb-1">Nenhum Favorito</h3>
                    <p class="text-slate-500 text-sm mb-6">Você ainda não marcou nenhum produto como favorito.</p>
                    <a href="carrinho.php?id=<?= $idParceiro ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white rounded-xl font-bold text-sm hover:opacity-90 transition-all">
                        <i class="ph-bold ph-shopping-cart"></i> Explorar Loja
                    </a>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    const idParceiro = '<?= $idParceiro ?>';
    const produtosServidor = <?= json_encode($produtos) ?>;
    let user = JSON.parse(localStorage.getItem('user_' + idParceiro));

    if (!user) { window.location.href = 'carrinho.php?id=' + idParceiro; }

    function renderFavoritos() {
        let favoritos = JSON.parse(localStorage.getItem('favoritos_<?= $idParceiro ?>')) || [];
        const grid = document.getElementById('favoritosGrid');
        const emptyState = document.getElementById('emptyState');

        document.getElementById('totalFavoritos').innerText = favoritos.length;

        if (favoritos.length === 0) {
            grid.classList.add('hidden');
            emptyState.classList.remove('hidden');
            return;
        }

        grid.classList.remove('hidden');
        emptyState.classList.add('hidden');
        grid.innerHTML = '';

        favoritos.forEach(idProduto => {
            const produto = produtosServidor.find(p => p.id === idProduto);
            if (produto) {
                const card = document.createElement('div');
                card.className = 'product-card';
                
                let imagemHTML = '';
                if (produto.imagens && produto.imagens.length > 0) {
                    imagemHTML = `<img src="${produto.imagens[0]}" alt="${produto.nome}" loading="lazy">`;
                } else {
                    imagemHTML = `<div class="text-5xl text-slate-300"><i class="ph-bold ph-package"></i></div>`;
                }
                
                const preco = produto.valor || produto.preco || 0;
                const precoFormatado = parseFloat(preco).toLocaleString('pt-BR', {minimumFractionDigits: 2});
                
                card.innerHTML = `
                    <div class="product-image">
                        ${imagemHTML}
                    </div>
                    <div class="p-4 flex flex-col flex-grow">
                        <h3 class="text-sm font-black text-slate-900 mb-1 line-clamp-2">${produto.nome || 'Produto'}</h3>
                        <p class="text-xs text-slate-500 mb-3 line-clamp-2 flex-grow">${produto.descricao || 'Produto premium'}</p>
                        <div class="flex items-baseline gap-2 mb-4">
                            <span class="text-lg font-black text-slate-900">R$ ${precoFormatado}</span>
                        </div>
                        <div class="flex gap-2">
                            <a href="detalhes.php?id=<?= $idParceiro ?>&produto=${produto.id}" class="btn-primary flex-1">
                                <i class="ph-bold ph-info"></i> Detalhes
                            </a>
                            <button onclick="adicionarAoCarrinho('${produto.id}')" class="btn-secondary flex-1">
                                <i class="ph-bold ph-shopping-cart"></i> Comprar
                            </button>
                            <button onclick="removerFavorito('${produto.id}')" class="btn-secondary hover:bg-red-50 hover:text-red-600">
                                <i class="ph-bold ph-trash text-red-500"></i>
                            </button>
                        </div>
                    </div>
                `;
                grid.appendChild(card);
            }
        });
    }

    function removerFavorito(idProduto) {
        let favoritos = JSON.parse(localStorage.getItem('favoritos_<?= $idParceiro ?>')) || [];
        const idx = favoritos.indexOf(idProduto);
        if (idx !== -1) {
            favoritos.splice(idx, 1);
            localStorage.setItem('favoritos_<?= $idParceiro ?>', JSON.stringify(favoritos));
            renderFavoritos();
            Swal.fire({
                toast: true, position: 'top-end', showConfirmButton: false, timer: 2000,
                icon: 'success', title: 'Removido dos favoritos!'
            });
        }
    }

    function adicionarAoCarrinho(idProduto) {
        const produto = produtosServidor.find(p => p.id === idProduto);
        if (produto) {
            let carrinho = JSON.parse(localStorage.getItem('carrinho_<?= $idParceiro ?>')) || [];
            carrinho.push(produto);
            localStorage.setItem('carrinho_<?= $idParceiro ?>', JSON.stringify(carrinho));
            Swal.fire({
                toast: true, position: 'top-end', showConfirmButton: false, timer: 2000,
                icon: 'success', title: 'Adicionado ao carrinho!'
            });
        }
    }

    renderFavoritos();
</script>
</body>
</html>
