<?php
/**
 * Meus Pedidos - Versão Premium v3.3
 * Ajuste: Imagens Ultra-Responsivas | Detalhes de Itens em Pagamentos | Layout Premium
 */

error_reporting(E_ALL); 
ini_set('display_errors', 0);
date_default_timezone_set('America/Sao_Paulo');

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$pedidos_file   = $base_path . 'pedidos.json';
$produtos_file  = $base_path . 'produtos.json';

function load_json($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) ?: [] : [];
}

$parceiros = load_json($parceiros_file);
$parceiro = null;
if (!empty($idParceiro)) {
    foreach($parceiros as $p) {
        if((string)($p['id'] ?? '') === $idParceiro) { $parceiro = $p; break; }
    }
}

if(!$parceiro) {
    ?>
    <!DOCTYPE html>
    <html lang="pt-br">
    <head>
        <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Loja não encontrada</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
        <style>body { font-family: 'Inter', sans-serif; }</style>
    </head>
    <body class="bg-[#f8fafc] h-screen flex items-center justify-center p-6">
        <div class="text-center max-w-md w-full bg-white p-10 rounded-[24px] shadow-xl border border-slate-100">
            <div class="w-20 h-20 bg-red-50 text-red-500 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fa-solid fa-store-slash text-3xl"></i>
            </div>
            <h1 class="text-2xl font-black text-slate-900 mb-2">Loja não encontrada</h1>
            <p class="text-slate-500 mb-8 text-sm">O link acessado é inválido ou a loja não está disponível.</p>
            <a href="index.php" class="block w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-sm hover:bg-slate-800 transition-all">Voltar ao Início</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

$all_pedidos = load_json($pedidos_file);
$all_produtos = load_json($produtos_file);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Meus Pedidos | <?= htmlspecialchars($parceiro['nome']) ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; font-family: 'Inter', sans-serif; }
        
        .tab-btn { padding: 12px 24px; font-size: 12px; font-weight: 800; text-transform: uppercase; letter-spacing: 0.1em; border-bottom: 3px solid transparent; transition: all 0.2s; color: #94a3b8; }
        .tab-btn.active { color: var(--p-color); border-bottom-color: var(--p-color); }

        .card { background: #fff; border-radius: 16px; border: 1px solid #e2e8f0; padding: 24px; transition: all 0.2s; }
        .card:hover { border-color: var(--p-color); box-shadow: 0 10px 25px -5px rgb(0 0 0 / 0.05); }
        
        .status-badge { padding: 6px 12px; border-radius: 8px; font-size: 10px; font-weight: 800; text-transform: uppercase; letter-spacing: 0.05em; display: inline-flex; align-items: center; gap: 6px; }
        .status-pago { background: #dcfce7; color: #166534; border: 1px solid #bbf7d0; }
        .status-pendente { background: #fef9c3; color: #854d0e; border: 1px solid #fef08a; }
        .status-cancelado { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }

        .btn-download { background-color: var(--p-color); color: #fff; padding: 12px 24px; border-radius: 12px; font-weight: 700; font-size: 13px; display: inline-flex; align-items: center; gap: 8px; transition: all 0.2s; }
        .btn-download:hover { opacity: 0.9; transform: translateY(-1px); box-shadow: 0 4px 12px rgba(var(--p-color), 0.2); }
        
        .product-img { width: 112px; height: 112px; border-radius: 16px; object-fit: contain; background: #f8fafc; border: 1px solid #e2e8f0; padding: 8px; }

        @media (max-width: 640px) {
            .card { padding: 16px; }
            .product-img { width: 88px; height: 88px; border-radius: 12px; }
            .tab-btn { padding: 12px 16px; font-size: 10px; }
        }
    </style>
</head>
<body>

<?php include 'includes/menu.php'; ?>

<main class="max-w-5xl mx-auto px-4 py-8 lg:py-12">
    <div class="mb-8">
        <div class="flex items-center gap-3 mb-2">
            <div class="w-2 h-8 bg-primary rounded-full"></div>
            <h1 class="text-3xl font-black text-slate-900 tracking-tight">Olá, <span id="clientName">Cliente</span>!</h1>
        </div>
        <p class="text-slate-500 text-sm ml-5">Gerencie seus pagamentos e acesse seus produtos digitais.</p>
    </div>

    <div class="flex border-b border-slate-200 mb-8 overflow-x-auto">
        <button onclick="switchTab('pagamentos')" id="tabPagamentos" class="tab-btn active">
            <i class="ph ph-credit-card mr-2"></i> Pagamentos
        </button>
        <button onclick="switchTab('produtos')" id="tabProdutos" class="tab-btn">
            <i class="ph ph-package mr-2"></i> Meus Produtos
        </button>
    </div>

    <div id="contentPagamentos" class="space-y-6"></div>
    <div id="contentProdutos" class="hidden space-y-6"></div>

    <div id="emptyState" class="hidden py-24 text-center bg-white rounded-[32px] border border-dashed border-slate-200 shadow-sm">
        <div class="w-24 h-24 bg-slate-50 text-slate-200 rounded-full flex items-center justify-center mx-auto mb-6">
            <i class="ph ph-package text-5xl"></i>
        </div>
        <h3 class="text-xl font-bold text-slate-900 mb-2">Nada por aqui ainda</h3>
        <p class="text-slate-400 text-sm mb-10 max-w-xs mx-auto">Você ainda não possui registros nesta seção.</p>
        <a href="index.php?id=<?= $idParceiro ?>" class="inline-block bg-primary text-white px-12 py-4 rounded-2xl font-bold text-sm transition-all hover:opacity-90 shadow-xl shadow-primary/20">Explorar Loja</a>
    </div>

    <div id="loginState" class="hidden py-24 text-center bg-white rounded-[32px] border border-slate-100 shadow-sm">
        <div class="w-24 h-24 bg-primary/5 text-primary rounded-full flex items-center justify-center mx-auto mb-6">
            <i class="ph ph-lock-key text-5xl"></i>
        </div>
        <h3 class="text-xl font-bold text-slate-900 mb-2">Acesso Restrito</h3>
        <p class="text-slate-400 text-sm mb-10 max-w-xs mx-auto">Faça login para visualizar seu histórico.</p>
        <a href="carrinho.php?id=<?= $idParceiro ?>" class="inline-block bg-primary text-white px-12 py-4 rounded-2xl font-bold text-sm transition-all hover:opacity-90 shadow-xl shadow-primary/20">Fazer Login</a>
    </div>
</main>

<script>
    const allPedidos = <?= json_encode($all_pedidos) ?>;
    const allProdutos = <?= json_encode($all_produtos) ?>;
    const idParceiro = "<?= $idParceiro ?>";
    let currentTab = 'pagamentos';

    function switchTab(tab) {
        currentTab = tab;
        document.getElementById('tabPagamentos').classList.toggle('active', tab === 'pagamentos');
        document.getElementById('tabProdutos').classList.toggle('active', tab === 'produtos');
        document.getElementById('contentPagamentos').classList.toggle('hidden', tab !== 'pagamentos');
        document.getElementById('contentProdutos').classList.toggle('hidden', tab !== 'produtos');
        render();
    }

    function getProductData(productId) {
        return allProdutos.find(p => p.id === productId) || null;
    }

    function render() {
        const user = JSON.parse(localStorage.getItem('user_' + idParceiro));
        const listPagamentos = document.getElementById('contentPagamentos');
        const listProdutos = document.getElementById('contentProdutos');
        const empty = document.getElementById('emptyState');
        const login = document.getElementById('loginState');
        const clientName = document.getElementById('clientName');

        if (!user) {
            login.classList.remove('hidden');
            listPagamentos.classList.add('hidden');
            listProdutos.classList.add('hidden');
            empty.classList.add('hidden');
            return;
        }

        clientName.innerText = user.nome.split(' ')[0];
        const meusPedidos = allPedidos.filter(p => p.id_cliente === user.id && p.id_parceiro === idParceiro);
        meusPedidos.sort((a, b) => new Date(b.data) - new Date(a.data));

        if (meusPedidos.length === 0) {
            empty.classList.remove('hidden');
            listPagamentos.classList.add('hidden');
            listProdutos.classList.add('hidden');
            login.classList.add('hidden');
            return;
        }

        empty.classList.add('hidden');
        login.classList.add('hidden');

        if (currentTab === 'pagamentos') {
            listPagamentos.classList.remove('hidden');
            listProdutos.classList.add('hidden');
            
            listPagamentos.innerHTML = meusPedidos.map(p => {
                const dataObj = new Date(p.data);
                const dataFormatada = dataObj.toLocaleDateString('pt-BR', { day: '2-digit', month: 'long', year: 'numeric' });
                const horaFormatada = dataObj.toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
                
                let statusClass = 'status-pendente';
                let statusText = 'Aguardando';
                let statusIcon = 'ph-clock';

                if (p.status_pagamento === 'pago') {
                    statusClass = 'status-pago';
                    statusText = 'Aprovado';
                    statusIcon = 'ph-check-circle';
                } else if (p.status_pagamento === 'cancelado') {
                    statusClass = 'status-cancelado';
                    statusText = 'Cancelado';
                    statusIcon = 'ph-x-circle';
                }

                return `
                    <div class="card">
                        <div class="flex flex-wrap justify-between items-center gap-4 mb-6">
                            <div>
                                <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] mb-1">Transação #${p.id.toUpperCase()}</p>
                                <p class="text-sm font-bold text-slate-900 flex items-center gap-2">
                                    <i class="ph ph-calendar text-slate-400"></i> ${dataFormatada} às ${horaFormatada}
                                </p>
                            </div>
                            <span class="status-badge ${statusClass}">
                                <i class="ph-fill ${statusIcon}"></i> ${statusText}
                            </span>
                        </div>
                        
                        <div class="space-y-3 mb-6">
                            ${p.itens.map(item => `
                                <div class="flex justify-between items-center text-sm">
                                    <div class="flex items-center gap-2">
                                        <span class="w-5 h-5 bg-slate-100 text-slate-500 text-[10px] font-bold flex items-center justify-center rounded-md">${item.qty || 1}x</span>
                                        <span class="text-slate-700 font-medium">${item.nome}</span>
                                    </div>
                                    <span class="text-slate-400 font-medium">R$ ${parseFloat(item.valor).toLocaleString('pt-BR', {minimumFractionDigits:2})}</span>
                                </div>
                            `).join('')}
                        </div>

                        <div class="flex justify-between items-center pt-6 border-t border-slate-100">
                            <div class="flex items-center gap-2 text-slate-400">
                                <i class="ph ph-credit-card text-lg"></i>
                                <span class="text-[10px] font-bold uppercase tracking-widest">${p.metodo === 'pix' ? 'Pix' : 'Saldo em Conta'}</span>
                            </div>
                            <div class="text-right">
                                <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mb-0.5">Valor Total</p>
                                <span class="text-xl font-black text-slate-900 tracking-tighter">R$ ${parseFloat(p.valor_total).toLocaleString('pt-BR', {minimumFractionDigits:2})}</span>
                            </div>
                        </div>
                    </div>
                `;
            }).join('');
        } else {
            listProdutos.classList.remove('hidden');
            listPagamentos.classList.add('hidden');

            const produtosPagos = [];
            meusPedidos.filter(p => p.status_pagamento === 'pago').forEach(p => {
                p.itens.forEach((item, index) => {
                    produtosPagos.push({ ...item, pedidoId: p.id, itemIndex: index, dataCompra: p.data });
                });
            });

            if (produtosPagos.length === 0) {
                listProdutos.innerHTML = `
                    <div class="py-12 text-center bg-white rounded-2xl border border-slate-100">
                        <p class="text-slate-400 text-sm">Nenhum produto liberado para download ainda.</p>
                    </div>
                `;
                return;
            }

            listProdutos.innerHTML = produtosPagos.map(item => {
                const prodData = getProductData(item.id);
                const dataObj = new Date(item.dataCompra);
                const dataFormatada = dataObj.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                const horaFormatada = dataObj.toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
                const imagem = (prodData && prodData.imagens && prodData.imagens.length > 0) ? prodData.imagens[0] : 'https://via.placeholder.com/150';
                const categoria = prodData ? prodData.categoria : 'Digital';

                return `
                    <div class="card flex flex-col sm:flex-row items-center gap-6 sm:gap-8">
                        <img src="${imagem}" class="product-img w-full sm:w-[112px]" onerror="this.src='https://via.placeholder.com/150'">
                        <div class="flex-grow min-w-0 text-center sm:text-left">
                            <div class="flex items-center justify-center sm:justify-start gap-2 mb-2">
                                <span class="px-2.5 py-1 bg-slate-100 text-slate-500 text-[10px] font-black uppercase tracking-widest rounded-lg">${categoria}</span>
                            </div>
                            <h4 class="font-bold text-slate-900 text-lg sm:text-xl truncate mb-1.5">${item.nome}</h4>
                            <div class="flex flex-col gap-1">
                                <p class="text-[11px] font-bold text-slate-400 uppercase tracking-widest">Adquirido em ${dataFormatada} às ${horaFormatada}</p>
                                <p class="text-[10px] font-medium text-slate-300 uppercase tracking-tighter">ID Pedido: #${item.pedidoId.toUpperCase()}</p>
                            </div>
                        </div>
                        <div class="w-full sm:w-auto">
                            ${item.file ? `
                                <a href="download.php?pedido=${item.pedidoId}&item=${item.itemIndex}&id=${idParceiro}" class="btn-download w-full sm:w-auto justify-center">
                                    <i class="ph ph-download-simple text-lg"></i> Baixar Arquivo
                                </a>
                            ` : `
                                <span class="text-[11px] font-bold text-slate-300 uppercase block text-center">Sem arquivo</span>
                            `}
                        </div>
                    </div>
                `;
            }).join('');
        }
    }

    render();
</script>
</body>
</html>
