<?php
/**
 * Página de Favoritos - favoritos.php (Layout Idêntico ao Original)
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$produtos_file  = $base_path . 'produtos.json';

function load_json_data($file) {
    if (!file_exists($file)) return [];
    $content = file_get_contents($file);
    return json_decode($content, true) ?: [];
}

$parceiros = load_json_data($parceiros_file);
$parceiro = null;
foreach($parceiros as $p){
    if((string)($p['id'] ?? '') === $idParceiro){
        $parceiro = $p;
        break;
    }
}

if(!$parceiro) {
    $parceiro = ['nome' => 'Loja Parceira', 'cor_primaria' => '#2563eb'];
}

$produtos = load_json_data($produtos_file);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Meus Favoritos | <?= htmlspecialchars($parceiro['nome']) ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; }
        
        /* Estilos Exatos do Card Original */
        .card-produto {
            background: #fff;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
            height: 100%;
            overflow: hidden;
            cursor: pointer;
        }

        .card-produto:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 20px -5px rgba(0,0,0,0.1);
            border-color: var(--p-color);
        }

        .img-wrapper {
            width: 100%;
            height: 240px;
            background: #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            padding: 10px;
        }

        .img-wrapper img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        .btn-cart {
            background-color: var(--p-color);
            color: #ffffff !important;
            padding: 12px;
            border-radius: 6px;
            font-weight: 600;
            width: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            transition: opacity 0.2s;
            border: none;
            cursor: pointer;
        }

        .btn-cart:hover { opacity: 0.9; }

        .heart-btn {
            position: absolute;
            top: 10px;
            right: 10px;
            z-index: 20;
            background: #fff;
            width: 34px;
            height: 34px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            cursor: pointer;
        }

        .heart-btn i { color: #cbd5e1; transition: color 0.2s; }
        .heart-btn.active i { color: #ef4444; }
    </style>
</head>
<body class="min-h-screen flex flex-col">

<?php include 'includes/menu.php'; ?>

<main class="max-w-7xl mx-auto px-4 py-12 w-full">
    <div class="flex flex-col md:flex-row md:items-end justify-between gap-6 mb-10">
        <div>
            <h1 class="text-4xl font-black text-slate-900 tracking-tighter uppercase italic leading-none">Meus Favoritos</h1>
            <p class="text-slate-500 text-sm mt-2">Produtos que você demonstrou interesse.</p>
        </div>
        <a href="index.php?id=<?= $idParceiro ?>" class="text-[10px] font-black text-slate-400 border border-slate-200 px-4 py-2 rounded-xl hover:bg-slate-50 transition-all uppercase tracking-widest text-center">Continuar Comprando</a>
    </div>

    <!-- Grid de Produtos (Layout Exato do Card) -->
    <div id="favoritosGrid" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
        <!-- JS preenche aqui -->
    </div>

    <!-- Estado Vazio -->
    <div id="emptyState" class="hidden py-20 text-center">
        <div class="w-20 h-20 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
            <i class="ph ph-heart-break text-4xl text-slate-300"></i>
        </div>
        <h2 class="text-xl font-black text-slate-800 uppercase tracking-tighter">Sua lista está vazia</h2>
        <p class="text-slate-400 text-sm mt-2 mb-8">Você ainda não favoritou nenhum produto.</p>
        <a href="index.php?id=<?= $idParceiro ?>" class="btn-primary px-10 py-4 rounded-2xl font-black text-[10px] uppercase tracking-widest inline-block">Explorar Loja</a>
    </div>
</main>

<script>
    const idParceiro = '<?= $idParceiro ?>';
    const produtosBase = <?= json_encode($produtos) ?>;
    
    function carregarFavoritos() {
        const favoritosIds = JSON.parse(localStorage.getItem('favoritos_' + idParceiro) || '[]');
        const grid = document.getElementById('favoritosGrid');
        const empty = document.getElementById('emptyState');
        
        const favoritos = produtosBase.filter(p => favoritosIds.includes(p.id));
        
        if (favoritos.length === 0) {
            grid.innerHTML = '';
            empty.classList.remove('hidden');
            return;
        }
        
        empty.classList.add('hidden');
        grid.innerHTML = favoritos.map(p => `
            <div class="card-produto">
                <div class="img-wrapper">
                    <img src="${p.imagens && p.imagens[0] ? p.imagens[0] : 'https://via.placeholder.com/300'}" alt="${p.nome}">
                    <div onclick="toggleFavorito('${p.id}')" class="heart-btn active">
                        <i class="ph-fill ph-heart text-xl"></i>
                    </div>
                </div>
                <div class="p-5 flex flex-col flex-grow">
                    <div class="flex justify-between items-start mb-2">
                        <span class="text-[10px] font-bold text-primary uppercase tracking-widest">${p.categoria}</span>
                    </div>
                    <h3 class="text-sm font-bold text-slate-800 leading-tight mb-4 line-clamp-2">${p.nome}</h3>
                    <div class="mt-auto">
                        <div class="flex items-baseline gap-1 mb-4">
                            <span class="text-[10px] font-bold text-slate-400 uppercase">R$</span>
                            <span class="text-xl font-black text-slate-900 tracking-tighter">${p.valor.toFixed(2).replace('.', ',')}</span>
                        </div>
                        <button onclick="adicionarAoCarrinho('${p.id}')" class="btn-cart">
                            <i class="ph ph-shopping-cart-simple text-lg"></i>
                            ADICIONAR
                        </button>
                    </div>
                </div>
            </div>
        `).join('');
    }

    function toggleFavorito(id) {
        let favoritos = JSON.parse(localStorage.getItem('favoritos_' + idParceiro) || '[]');
        favoritos = favoritos.filter(favId => favId !== id);
        localStorage.setItem('favoritos_' + idParceiro, JSON.stringify(favoritos));
        
        Swal.fire({
            toast: true,
            position: 'top-end',
            icon: 'success',
            title: 'Removido dos favoritos',
            showConfirmButton: false,
            timer: 2000
        });
        
        carregarFavoritos();
        if(typeof atualizarMenu === 'function') atualizarMenu();
    }

    function adicionarAoCarrinho(id) {
        const produto = produtosBase.find(p => p.id === id);
        if (!produto) return;

        let carrinho = JSON.parse(localStorage.getItem('carrinho_' + idParceiro) || '[]');
        const index = carrinho.findIndex(item => item.id === id);

        if (index > -1) {
            carrinho[index].quantidade += 1;
        } else {
            carrinho.push({
                id: produto.id,
                nome: produto.nome,
                valor: produto.valor,
                imagem: produto.imagens && produto.imagens[0] ? produto.imagens[0] : '',
                quantidade: 1
            });
        }

        localStorage.setItem('carrinho_' + idParceiro, JSON.stringify(carrinho));
        
        Swal.fire({
            toast: true,
            position: 'top-end',
            icon: 'success',
            title: 'Adicionado ao carrinho!',
            showConfirmButton: false,
            timer: 2000
        });
        
        if(typeof atualizarMenu === 'function') atualizarMenu();
    }

    carregarFavoritos();
</script>

</body>
</html>
