<?php
/**
 * Meus Pedidos - Versão Premium
 * Layout Profissional | Histórico de Compras | Downloads
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$pedidos_file   = $base_path . 'pedidos.json';

function load_json($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) ?: [] : [];
}

$parceiros = load_json($parceiros_file);
$parceiro = null;
if (!empty($idParceiro)) {
    foreach($parceiros as $p) {
        if((string)($p['id'] ?? '') === $idParceiro) { $parceiro = $p; break; }
    }
}

// Página de Erro: Parceiro não encontrado
if(!$parceiro) {
    ?>
    <!DOCTYPE html>
    <html lang="pt-br">
    <head>
        <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Loja não encontrada</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
        <style>body { font-family: 'Inter', sans-serif; }</style>
    </head>
    <body class="bg-[#f8fafc] h-screen flex items-center justify-center p-6">
        <div class="text-center max-w-md w-full bg-white p-10 rounded-[24px] shadow-xl border border-slate-100">
            <div class="w-20 h-20 bg-red-50 text-red-500 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fa-solid fa-store-slash text-3xl"></i>
            </div>
            <h1 class="text-2xl font-black text-slate-900 mb-2">Loja não encontrada</h1>
            <p class="text-slate-500 mb-8 text-sm">O link acessado é inválido ou a loja não está disponível.</p>
            <a href="index.php" class="block w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-sm hover:bg-slate-800 transition-all">Voltar ao Início</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

$all_pedidos = load_json($pedidos_file);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Meus Pedidos | <?= htmlspecialchars($parceiro['nome']) ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; font-family: 'Inter', sans-serif; }
        
        header {
            background: #fff;
            border-bottom: 1px solid #e2e8f0;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .card { background: #fff; border-radius: 12px; border: 1px solid #e2e8f0; padding: 20px; transition: all 0.2s; }
        .card:hover { border-color: var(--p-color); box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.05); }
        
        .status-badge { padding: 4px 10px; border-radius: 6px; font-size: 10px; font-weight: 800; text-transform: uppercase; letter-spacing: 0.05em; }
        .status-pago { background: #dcfce7; color: #166534; }
        .status-pendente { background: #fef9c3; color: #854d0e; }
        .status-cancelado { background: #fee2e2; color: #991b1b; }

        .btn-download { background-color: var(--p-color); color: #fff; padding: 8px 16px; border-radius: 8px; font-weight: 700; font-size: 12px; display: inline-flex; align-items: center; gap: 8px; transition: all 0.2s; }
        .btn-download:hover { opacity: 0.9; transform: translateY(-1px); }
        
        @media (max-width: 640px) {
            .card { padding: 16px; }
        }
    </style>
</head>
<body>

<header>
    <div class="max-w-5xl mx-auto px-4 h-16 flex justify-between items-center">
        <div class="flex items-center gap-3">
            <a href="index.php?id=<?= $idParceiro ?>" class="w-8 h-8 flex items-center justify-center rounded-full hover:bg-slate-100 transition-colors text-slate-500">
                <i class="ph ph-arrow-left text-lg"></i>
            </a>
            <?php if(!empty($parceiro['logo'])): ?>
                <img src="<?= htmlspecialchars($parceiro['logo']) ?>" alt="<?= htmlspecialchars($parceiro['nome']) ?>" class="h-6 w-auto object-contain">
            <?php else: ?>
                <span class="font-bold text-lg text-slate-900 tracking-tight"><?= htmlspecialchars($parceiro['nome']) ?></span>
            <?php endif; ?>
        </div>
        <div class="flex items-center gap-4">
            <div id="userProfile" class="hidden flex items-center gap-2">
                <div class="w-8 h-8 bg-primary/10 text-primary rounded-full flex items-center justify-center">
                    <i class="ph-fill ph-user text-sm"></i>
                </div>
                <span id="userName" class="text-xs font-bold text-slate-700 hidden sm:block"></span>
            </div>
        </div>
    </div>
</header>

<main class="max-w-5xl mx-auto px-4 py-8 lg:py-12">
    <div class="mb-8">
        <h1 class="text-2xl font-black text-slate-900 tracking-tight mb-2">Meus Pedidos</h1>
        <p class="text-slate-500 text-sm">Acompanhe suas compras e acesse seus downloads.</p>
    </div>

    <div id="pedidosList" class="space-y-4"></div>

    <div id="emptyState" class="hidden py-20 text-center bg-white rounded-[24px] border border-dashed border-slate-200">
        <div class="w-20 h-20 bg-slate-50 text-slate-200 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="ph ph-package text-4xl"></i>
        </div>
        <h3 class="text-lg font-bold text-slate-900 mb-2">Nenhum pedido encontrado</h3>
        <p class="text-slate-400 text-xs mb-8 max-w-xs mx-auto">Você ainda não realizou nenhuma compra nesta loja.</p>
        <a href="index.php?id=<?= $idParceiro ?>" class="inline-block bg-primary text-white px-10 py-4 rounded-xl font-bold text-xs transition-all hover:opacity-90 shadow-lg shadow-primary/20">Ir para a Loja</a>
    </div>

    <div id="loginState" class="hidden py-20 text-center bg-white rounded-[24px] border border-slate-100 shadow-sm">
        <div class="w-20 h-20 bg-primary/5 text-primary rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="ph ph-lock-key text-4xl"></i>
        </div>
        <h3 class="text-lg font-bold text-slate-900 mb-2">Acesso Restrito</h3>
        <p class="text-slate-400 text-xs mb-8 max-w-xs mx-auto">Você precisa estar logado para visualizar seus pedidos.</p>
        <a href="carrinho.php?id=<?= $idParceiro ?>" class="inline-block bg-primary text-white px-10 py-4 rounded-xl font-bold text-xs transition-all hover:opacity-90 shadow-lg shadow-primary/20">Fazer Login</a>
    </div>
</main>

<script>
    const allPedidos = <?= json_encode($all_pedidos) ?>;
    const idParceiro = "<?= $idParceiro ?>";

    function render() {
        const user = JSON.parse(localStorage.getItem('user_' + idParceiro));
        const list = document.getElementById('pedidosList');
        const empty = document.getElementById('emptyState');
        const login = document.getElementById('loginState');
        const profile = document.getElementById('userProfile');
        const nameSpan = document.getElementById('userName');

        if (!user) {
            login.classList.remove('hidden');
            list.classList.add('hidden');
            empty.classList.add('hidden');
            profile.classList.add('hidden');
            return;
        }

        profile.classList.remove('hidden');
        nameSpan.innerText = user.nome.split(' ')[0];
        
        const meusPedidos = allPedidos.filter(p => p.id_cliente === user.id && p.id_parceiro === idParceiro);

        if (meusPedidos.length === 0) {
            empty.classList.remove('hidden');
            list.classList.add('hidden');
            login.classList.add('hidden');
            return;
        }

        empty.classList.add('hidden');
        login.classList.add('hidden');
        list.classList.remove('hidden');

        meusPedidos.sort((a, b) => new Date(b.data) - new Date(a.data));

        list.innerHTML = meusPedidos.map(p => {
            const data = new Date(p.data).toLocaleDateString('pt-BR', { day: '2-digit', month: 'long', year: 'numeric' });
            const statusClass = p.status_pagamento === 'pago' ? 'status-pago' : (p.status_pagamento === 'cancelado' ? 'status-cancelado' : 'status-pendente');
            const statusText = p.status_pagamento === 'pago' ? 'Pago' : (p.status_pagamento === 'cancelado' ? 'Cancelado' : 'Aguardando');

            return `
                <div class="card">
                    <div class="flex flex-wrap justify-between items-start gap-4 mb-6">
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Pedido #${p.id.toUpperCase()}</p>
                            <p class="text-sm font-bold text-slate-900">${data}</p>
                        </div>
                        <span class="status-badge ${statusClass}">${statusText}</span>
                    </div>

                    <div class="space-y-4 mb-6">
                        ${p.itens.map(item => `
                            <div class="flex justify-between items-center py-3 border-b border-slate-50 last:border-0">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 bg-slate-50 rounded-lg flex items-center justify-center text-slate-400">
                                        <i class="ph ph-file-zip text-xl"></i>
                                    </div>
                                    <div>
                                        <p class="text-xs font-bold text-slate-800">${item.nome}</p>
                                        <p class="text-[10px] text-slate-400">${item.qty || 1} unidade(s)</p>
                                    </div>
                                </div>
                                ${p.status_pagamento === 'pago' && item.file ? `
                                    <a href="downloads/${item.file}" download class="btn-download">
                                        <i class="ph ph-download-simple"></i> Baixar
                                    </a>
                                ` : `
                                    <span class="text-xs font-bold text-slate-900">R$ ${parseFloat(item.valor).toLocaleString('pt-BR', {minimumFractionDigits:2})}</span>
                                `}
                            </div>
                        `).join('')}
                    </div>

                    <div class="flex justify-between items-center pt-4 border-t border-slate-100">
                        <span class="text-xs font-bold text-slate-400 uppercase tracking-widest">Total Pago</span>
                        <span class="text-lg font-black text-slate-900 tracking-tight">R$ ${parseFloat(p.valor_total).toLocaleString('pt-BR', {minimumFractionDigits:2})}</span>
                    </div>
                </div>
            `;
        }).join('');
    }

    render();
</script>
</body>
</html>
