<?php
/**
 * Página de Carrinho - Integração PushinPay (Versão Final Corrigida)
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

$idParceiro = isset($_GET['id']) ? (string)$_GET['id'] : '';
$base_path = __DIR__ . '/data/';
$parceiros_file = $base_path . 'parceiros.json';
$clientes_file  = $base_path . 'clientes.json';
$pedidos_file   = $base_path . 'pedidos.json';

function load_json_data($file) {
    if (!file_exists($file)) return [];
    $content = file_get_contents($file);
    return json_decode($content, true) ?: [];
}

function save_json_data($file, $data) {
    if (!is_dir(dirname($file))) {
        mkdir(dirname($file), 0755, true);
    }
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$parceiros = load_json_data($parceiros_file);
$parceiro = null;
foreach($parceiros as $p){
    if((string)($p['id'] ?? '') === $idParceiro){
        $parceiro = $p;
        break;
    }
}

if(!$parceiro) {
    $parceiro = ['nome' => 'Loja Parceira', 'cor_primaria' => '#2563eb', 'token' => ''];
}

// API Interna
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $clientes = load_json_data($clientes_file);

    if ($_POST['action'] === 'login') {
        $email = $_POST['email'] ?? '';
        $senha = $_POST['senha'] ?? '';
        foreach ($clientes as $c) {
            if ($c['email'] === $email && $c['senha'] === $senha && (string)$c['id_parceiro'] === $idParceiro) {
                echo json_encode(['success' => true, 'cliente' => $c]);
                exit;
            }
        }
        echo json_encode(['success' => false, 'message' => 'E-mail ou senha incorretos.']);
        exit;
    }

    if ($_POST['action'] === 'cadastrar') {
        $email = $_POST['email'] ?? '';
        foreach ($clientes as $c) {
            if ($c['email'] === $email && (string)$c['id_parceiro'] === $idParceiro) {
                echo json_encode(['success' => false, 'message' => 'E-mail já cadastradoneste parceiro.']);
                exit;
            }
        }
        $novoCliente = [
            "id" => "c" . uniqid(),
            "id_parceiro" => $idParceiro,
            "nome" => $_POST['nome'],
            "email" => $email,
            "senha" => $_POST['senha'],
            "whatsapp" => $_POST['whatsapp'],
            "saldo" => 0.0,
            "status" => "ativo",
            "criado_em" => date('c')
        ];
        $clientes[] = $novoCliente;
        save_json_data($clientes_file, $clientes);
        echo json_encode(['success' => true, 'cliente' => $novoCliente]);
        exit;
    }

    if ($_POST['action'] === 'finalizar_pedido') {
        $idCliente = $_POST['id_cliente'] ?? '';
        $valorTotal = (float)($_POST['valor_total'] ?? 0);
        $metodo = $_POST['metodo_pagamento'] ?? '';
        $itens = json_decode($_POST['itens'] ?? '[]', true);

        if (empty($idCliente) || empty($itens) || $valorTotal <= 0) {
            echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
            exit;
        }

        $clienteIndex = -1;
        foreach ($clientes as $idx => $c) {
            if ($c['id'] === $idCliente) { $clienteIndex = $idx; break; }
        }

        if ($clienteIndex === -1) { echo json_encode(['success' => false, 'message' => 'Cliente não encontrado.']); exit; }

        $statusPagamento = 'pendente';
        if ($metodo === 'saldo') {
            if ($clientes[$clienteIndex]['saldo'] < $valorTotal) {
                echo json_encode(['success' => false, 'message' => 'Saldo insuficiente.']);
                exit;
            }
            $clientes[$clienteIndex]['saldo'] -= $valorTotal;
            save_json_data($clientes_file, $clientes);
            $statusPagamento = 'pago';
        }

        $pedidos = load_json_data($pedidos_file);
$pedidoId = "p" . date('YmdHis') . rand(100, 999);

$novoPedido = [
    "id" => $pedidoId,
    "id_parceiro" => $idParceiro,
    "id_cliente" => $idCliente,
    "valor_total" => $valorTotal,
    "metodo" => $metodo,

    "status_pagamento" => $statusPagamento,
    "status_pix" => $metodo === 'pix' ? 'aguardando' : null,

    "pix" => $metodo === 'pix' ? [
        "external_id" => $pedidoId,
        "cashin_id" => null,
        "txid" => null,
        "valor_esperado" => (int) round($valorTotal * 100),
        "valor_pago" => null,
        "qr_code" => null,
        "qr_code_base64" => null,
        "criado_em" => date('c'),
        "pago_em" => null
    ] : null,

    "arquivos" => array_map(fn($i) => [
        'nome' => $i['nome'],
        'file' => $i['file'] ?? null
    ], $itens),

    "data" => date('c')
];

$pedidos[] = $novoPedido;
save_json_data($pedidos_file, $pedidos);

        $pixData = null;
        if ($metodo === 'pix') {
            $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
            $host = $_SERVER['HTTP_HOST'];
            $webhookUrl = "$protocol://$host/webhook.php";

            $ch = curl_init('https://api.pushinpay.com.br/api/pix/cashIn');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                "value" => (int)round($valorTotal * 100),
                "webhook_url" => $webhookUrl,
                "external_id" => $pedidoId
            ]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . ($parceiro['token'] ?? ''),
                'Accept: application/json',
                'Content-Type: application/json'
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);
            $pixData = json_decode($response, true);
        }
        
        if ($metodo === 'pix' && (isset($pixData['cashin_id']) || isset($pixData['id']))) {
    foreach ($pedidos as &$p) {
        if ($p['id'] === $pedidoId) {

            // 🔑 ID REAL DO PIX (usado no webhook)
            $p['pix']['id'] = $pixData['cashin_id'] ?? $pixData['id'];

            // Mantém por compatibilidade
            $p['pix']['cashin_id'] = $p['pix']['id'];

            $p['pix']['qr_code'] = $pixData['qr_code'] ?? null;
            break;
        }
    }
    save_json_data($pedidos_file, $pedidos);
}

        echo json_encode([
            'success' => true, 
            'pedido_id' => $pedidoId,
            'status_pagamento' => $statusPagamento,
            'pix' => $pixData,
            'novo_saldo' => $clientes[$clienteIndex]['saldo']
        ]);
        exit;
    }

    if ($_POST['action'] === 'verificar_status') {
        $pedidoId = $_POST['pedido_id'];
        $pedidos = load_json_data($pedidos_file);
        foreach ($pedidos as $p) {
            if ($p['id'] === $pedidoId) {
                echo json_encode(['status' => $p['status_pagamento']]);
                exit;
            }
        }
        echo json_encode(['status' => 'nao_encontrado']);
        exit;
    }

    if ($_POST['action'] === 'cancelar_pedido') {
        $pedidoId = $_POST['pedido_id'];
        $pedidos = load_json_data($pedidos_file);
        foreach ($pedidos as &$p) {
            if ($p['id'] === $pedidoId && $p['status_pagamento'] === 'pendente') {
                $p['status_pagamento'] = 'cancelado';

if ($p['pix']) {
    $p['status_pix'] = 'cancelado';
}
                save_json_data($pedidos_file, $pedidos);
                echo json_encode(['success' => true]);
                exit;
            }
        }
        echo json_encode(['success' => false]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Carrinho | <?= htmlspecialchars($parceiro['nome']) ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { primary: '<?= $parceiro['cor_primaria'] ?? "#2563eb" ?>' },
                    fontFamily: { sans: ['Inter', 'sans-serif'] }
                }
            }
        }
    </script>
    <style>
        :root { --p-color: <?= $parceiro['cor_primaria'] ?? "#2563eb" ?>; }
        body { background-color: #f8fafc; color: #1e293b; }
        .btn-primary { background-color: var(--p-color); color: #fff !important; transition: all 0.3s; }
        .btn-primary:hover { opacity: 0.9; transform: translateY(-1px); }
        .card-checkout { background: #fff; border: 1px solid #e2e8f0; border-radius: 12px; }
        .input-checkout { width: 100%; padding: 12px; border-radius: 8px; border: 1px solid #e2e8f0; outline: none; }
        .input-checkout:focus { border-color: var(--p-color); }
        .metodo-card { border: 2px solid #f1f5f9; border-radius: 12px; cursor: pointer; transition: all 0.2s; }
        .metodo-card.active { border-color: var(--p-color); background: rgba(var(--p-color), 0.02); }
        .pix-container { background: #fff; border-radius: 16px; padding: 20px; text-align: center; }
        .copy-box { background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 8px; padding: 10px; font-family: monospace; font-size: 11px; word-break: break-all; margin: 15px 0; }
    </style>
</head>
<body>

<?php include 'includes/menu.php'; ?>

<main class="max-w-6xl mx-auto px-4 py-10">
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
        <div class="lg:col-span-7 space-y-6">
            <section class="card-checkout p-6">
                <h2 class="font-bold text-slate-800 mb-6 flex items-center gap-2">
                    <i class="ph ph-shopping-cart text-primary"></i> Itens Selecionados
                </h2>
                <div id="cartItemsList" class="divide-y divide-slate-100"></div>
                <div id="emptyCart" class="hidden py-10 text-center text-slate-400">Seu carrinho está vazio.</div>
            </section>

            <section id="sectionAuth" class="card-checkout p-6">
                <div id="authContent">
                    <div class="flex gap-6 mb-6 border-b border-slate-100">
                        <button onclick="switchTab('login')" id="tabLogin" class="pb-3 font-bold text-sm border-b-2 border-primary text-primary">Entrar</button>
                        <button onclick="switchTab('cadastro')" id="tabCadastro" class="pb-3 font-bold text-sm border-b-2 border-transparent text-slate-400">Criar Conta</button>
                    </div>
                    <div id="loginForm" class="space-y-4">
                        <input type="email" id="loginEmail" class="input-checkout" placeholder="E-mail">
                        <input type="password" id="loginSenha" class="input-checkout" placeholder="Senha">
                        <button onclick="realizarLogin()" class="btn-primary w-full py-3 rounded-lg font-bold">Acessar Conta</button>
                    </div>
                    <div id="cadastroForm" class="hidden space-y-4">
                        <input type="text" id="regNome" class="input-checkout" placeholder="Nome Completo">
                        <input type="email" id="regEmail" class="input-checkout" placeholder="E-mail">
                        <input type="password" id="regSenha" class="input-checkout" placeholder="Senha">
                        <input type="text" id="regWhatsapp" class="input-checkout" placeholder="WhatsApp">
                        <button onclick="realizarCadastro()" class="btn-primary w-full py-3 rounded-lg font-bold">Cadastrar e Continuar</button>
                    </div>
                </div>
                <div id="clienteLogadoView" class="hidden flex items-center justify-between bg-slate-50 p-4 rounded-xl border border-slate-100">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-primary/10 rounded-full flex items-center justify-center text-primary"><i class="ph-fill ph-user"></i></div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase">Logado como</p>
                            <p id="displayNome" class="font-bold text-slate-800"></p>
                        </div>
                    </div>
                    <button onclick="logout()" class="text-xs font-bold text-red-500">SAIR</button>
                </div>
            </section>
        </div>

        <div id="summaryColumn" class="lg:col-span-5 space-y-6">
            <div class="card-checkout p-6 sticky top-24">
                <h2 class="text-lg font-bold text-slate-800 mb-6">Resumo do Pedido</h2>
                <div class="space-y-3 mb-6">
                    <div class="flex justify-between text-slate-500"><span>Subtotal</span><span id="subtotalValue">R$ 0,00</span></div>
                    <div class="flex justify-between text-slate-500"><span>Entrega</span><span class="text-green-600">Grátis</span></div>
                    <div class="pt-4 border-t border-slate-100 flex justify-between items-center">
                        <span class="font-bold text-slate-800">Total</span>
                        <span id="totalValue" class="text-2xl font-black text-slate-900">R$ 0,00</span>
                    </div>
                </div>
                <div id="saldoContainer" class="hidden mb-6 p-4 bg-primary/5 rounded-xl border border-primary/10">
                    <div class="flex justify-between items-center mb-1">
                        <span class="text-[10px] font-bold text-primary uppercase">Saldo Disponível</span>
                        <i class="ph ph-wallet text-primary"></i>
                    </div>
                    <div id="saldoDisplay" class="text-xl font-black text-primary">R$ 0,00</div>
                </div>
                <div class="space-y-3 mb-6">
                    <p class="text-[10px] font-bold text-slate-400 uppercase">Forma de Pagamento</p>
                    <div class="grid grid-cols-2 gap-3">
                        <div onclick="setMetodo('saldo')" id="cardSaldo" class="metodo-card p-3 flex flex-col items-center gap-1 active">
                            <i class="ph ph-wallet text-xl text-slate-400"></i>
                            <span class="text-[10px] font-bold uppercase">Saldo</span>
                        </div>
                        <div onclick="setMetodo('pix')" id="cardPix" class="metodo-card p-3 flex flex-col items-center gap-1">
                            <i class="ph ph-qr-code text-xl text-slate-400"></i>
                            <span class="text-[10px] font-bold uppercase">Pix</span>
                        </div>
                    </div>
                </div>
                <button onclick="finalizarPedido()" id="btnFinalizar" class="btn-primary w-full py-4 rounded-xl font-bold text-sm uppercase tracking-wider shadow-lg">
                    Finalizar Pedido
                </button>
            </div>
        </div>
    </div>
</main>

<script>
    let carrinho = JSON.parse(localStorage.getItem('carrinho_<?= $idParceiro ?>')) || [];
    const idParceiro = '<?= $idParceiro ?>';
    let metodoPagamento = 'saldo';

    function renderCart() {
        const list = document.getElementById('cartItemsList');
        const empty = document.getElementById('emptyCart');
        const summary = document.getElementById('summaryColumn');
        if (carrinho.length === 0) { 
            list.innerHTML = ''; empty.classList.remove('hidden'); summary.classList.add('hidden'); return; 
        }
        empty.classList.add('hidden'); summary.classList.remove('hidden');
        const grouped = carrinho.reduce((acc, item) => {
            if (!acc[item.id]) acc[item.id] = { ...item, qty: 0 };
            acc[item.id].qty++; return acc;
        }, {});
        list.innerHTML = Object.values(grouped).map(item => `
            <div class="py-4 flex items-center gap-4">
                <div class="w-12 h-12 bg-slate-50 rounded-lg flex items-center justify-center p-1 border border-slate-100">
                    <img src="${item.imagem || (item.imagens ? item.imagens[0] : '')}" class="max-w-full max-h-full object-contain">
                </div>
                <div class="flex-grow">
                    <h4 class="font-bold text-slate-800 text-xs">${item.nome}</h4>
                    <span class="text-primary font-bold text-xs">R$ ${item.valor.toLocaleString('pt-BR', {minimumFractionDigits: 2})}</span>
                </div>
                <div class="flex items-center gap-2 bg-slate-50 px-2 py-1 rounded-lg">
                    <button onclick="updateQty('${item.id}', -1)" class="text-slate-400 hover:text-primary"><i class="ph-bold ph-minus text-[10px]"></i></button>
                    <span class="text-xs font-bold w-4 text-center">${item.qty}</span>
                    <button onclick="updateQty('${item.id}', 1)" class="text-slate-400 hover:text-primary"><i class="ph-bold ph-plus text-[10px]"></i></button>
                </div>
                <button onclick="removeItem('${item.id}')" class="text-slate-300 hover:text-red-500"><i class="ph ph-trash"></i></button>
            </div>
        `).join('');
        const total = carrinho.reduce((acc, item) => acc + item.valor, 0);
        document.getElementById('subtotalValue').innerText = `R$ ${total.toLocaleString('pt-BR', {minimumFractionDigits: 2})}`;
        document.getElementById('totalValue').innerText = `R$ ${total.toLocaleString('pt-BR', {minimumFractionDigits: 2})}`;
    }

    function updateQty(id, delta) {
        if (delta > 0) { const item = carrinho.find(i => i.id === id); carrinho.push({ ...item }); }
        else { const idx = carrinho.findIndex(i => i.id === id); carrinho.splice(idx, 1); }
        localStorage.setItem('carrinho_' + idParceiro, JSON.stringify(carrinho));
        renderCart();
        if(window.atualizarMenuGlobal) window.atualizarMenuGlobal();
    }

    function removeItem(id) {
        carrinho = carrinho.filter(i => i.id !== id);
        localStorage.setItem('carrinho_' + idParceiro, JSON.stringify(carrinho));
        renderCart();
        if(window.atualizarMenuGlobal) window.atualizarMenuGlobal();
    }

    function switchTab(tab) {
        const isLogin = tab === 'login';
        document.getElementById('tabLogin').className = isLogin ? 'pb-3 font-bold text-sm border-b-2 border-primary text-primary' : 'pb-3 font-bold text-sm border-b-2 border-transparent text-slate-400';
        document.getElementById('tabCadastro').className = !isLogin ? 'pb-3 font-bold text-sm border-b-2 border-primary text-primary' : 'pb-3 font-bold text-sm border-b-2 border-transparent text-slate-400';
        document.getElementById('loginForm').classList.toggle('hidden', !isLogin);
        document.getElementById('cadastroForm').classList.toggle('hidden', isLogin);
    }

    function checkLogin() {
        const cliente = JSON.parse(localStorage.getItem('cliente_logado_' + idParceiro));
        if (cliente) {
            document.getElementById('authContent').classList.add('hidden');
            document.getElementById('clienteLogadoView').classList.remove('hidden');
            document.getElementById('displayNome').innerText = cliente.nome;
            document.getElementById('saldoContainer').classList.remove('hidden');
            document.getElementById('saldoDisplay').innerText = `R$ ${parseFloat(cliente.saldo).toLocaleString('pt-BR', {minimumFractionDigits: 2})}`;
        } else {
            document.getElementById('authContent').classList.remove('hidden');
            document.getElementById('clienteLogadoView').classList.add('hidden');
            document.getElementById('saldoContainer').classList.add('hidden');
        }
    }

    function realizarLogin() {
        const email = document.getElementById('loginEmail').value;
        const senha = document.getElementById('loginSenha').value;
        if (!email || !senha) return Swal.fire('Erro', 'Preencha todos os campos', 'error');
        const formData = new FormData();
        formData.append('action', 'login');
        formData.append('email', email);
        formData.append('senha', senha);
        fetch('carrinho.php?id=' + idParceiro, { method: 'POST', body: formData }).then(r => r.json()).then(data => {
            if (data.success) {
                localStorage.setItem('cliente_logado_' + idParceiro, JSON.stringify(data.cliente));
                checkLogin();
                if(window.atualizarMenuGlobal) window.atualizarMenuGlobal();
            } else { Swal.fire('Erro', data.message, 'error'); }
        });
    }

    function realizarCadastro() {
        const nome = document.getElementById('regNome').value;
        const email = document.getElementById('regEmail').value;
        const senha = document.getElementById('regSenha').value;
        const whatsapp = document.getElementById('regWhatsapp').value;
        if (!nome || !email || !senha) return Swal.fire('Erro', 'Preencha os campos obrigatórios', 'error');
        const formData = new FormData();
        formData.append('action', 'cadastrar');
        formData.append('nome', nome);
        formData.append('email', email);
        formData.append('senha', senha);
        formData.append('whatsapp', whatsapp);
        fetch('carrinho.php?id=' + idParceiro, { method: 'POST', body: formData }).then(r => r.json()).then(data => {
            if (data.success) {
                localStorage.setItem('cliente_logado_' + idParceiro, JSON.stringify(data.cliente));
                checkLogin();
                if(window.atualizarMenuGlobal) window.atualizarMenuGlobal();
            } else { Swal.fire('Erro', data.message, 'error'); }
        });
    }

    function logout() {
        localStorage.removeItem('cliente_logado_' + idParceiro);
        checkLogin();
        if(window.atualizarMenuGlobal) window.atualizarMenuGlobal();
    }

    function setMetodo(m) {
        metodoPagamento = m;
        document.getElementById('cardSaldo').className = m === 'saldo' ? 'metodo-card p-3 flex flex-col items-center gap-1 active' : 'metodo-card p-3 flex flex-col items-center gap-1';
        document.getElementById('cardPix').className = m === 'pix' ? 'metodo-card p-3 flex flex-col items-center gap-1 active' : 'metodo-card p-3 flex flex-col items-center gap-1';
    }

    function finalizarPedido() {
        const cliente = JSON.parse(localStorage.getItem('cliente_logado_' + idParceiro));
        if (!cliente) return Swal.fire('Atenção', 'Faça login para finalizar o pedido', 'warning');
        if (carrinho.length === 0) return Swal.fire('Erro', 'Seu carrinho está vazio', 'error');
        const total = carrinho.reduce((acc, item) => acc + item.valor, 0);
        const formData = new FormData();
        formData.append('action', 'finalizar_pedido');
        formData.append('id_cliente', cliente.id);
        formData.append('valor_total', total);
        formData.append('metodo_pagamento', metodoPagamento);
        formData.append('itens', JSON.stringify(carrinho));
        Swal.fire({ title: 'Processando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
        fetch('carrinho.php?id=' + idParceiro, { method: 'POST', body: formData }).then(r => r.json()).then(data => {
            Swal.close();
            if (data.success) {
                if (metodoPagamento === 'saldo') {
                    localStorage.removeItem('carrinho_' + idParceiro);
                    cliente.saldo = data.novo_saldo;
                    localStorage.setItem('cliente_logado_' + idParceiro, JSON.stringify(cliente));
                    Swal.fire('Sucesso!', 'Pedido realizado com saldo!', 'success').then(() => { window.location.href = 'downloads.php?id=' + idParceiro; });
                } else { showPixModal(data.pix, data.pedido_id); }
            } else { Swal.fire('Erro', data.message, 'error'); }
        });
    }

function showPixModal(pix, pedidoId) {

    if (!pix || !pix.qr_code) {
        return Swal.fire('Erro', 'Erro ao gerar Pix', 'error');
    }

    // Trata Base64 apenas se existir
    let qrImgHtml = '';
    if (pix.qr_code_base64) {
        const base64Data = pix.qr_code_base64
            .replace(/^data:image\/[a-z]+;base64,/, '')
            .replace(/\s/g, '');

        qrImgHtml = `
            <div class="bg-white p-2 inline-block rounded-xl border border-slate-100 mb-4">
                <img src="data:image/png;base64,${base64Data}"
                     class="mx-auto w-48 h-48"
                     style="display:block">
            </div>
        `;
    } else {
        qrImgHtml = `
            <p class="text-xs text-orange-500 mb-3 text-center">
                QR Code indisponível, use o código Pix abaixo
            </p>
        `;
    }

    Swal.fire({
        title: 'Pagamento via Pix',
        html: `
            <div class="pix-container text-center">
                ${qrImgHtml}

                <p class="text-xs text-slate-500 mb-2">
                    Copie o código abaixo para pagar:
                </p>

                <div class="copy-box" id="pixCode">${pix.qr_code}</div>

                <div class="grid grid-cols-1 gap-2 mt-3">
                    <button onclick="copyPix()"
                        class="btn-primary px-6 py-3 rounded-lg text-xs font-bold uppercase">
                        COPIAR CÓDIGO
                    </button>

                    <button onclick="cancelarPedido('${pedidoId}')"
                        class="bg-slate-100 text-slate-500 px-6 py-3 rounded-lg text-[10px] font-bold uppercase">
                        CANCELAR PEDIDO
                    </button>
                </div>

                <div class="mt-6 flex items-center justify-center gap-2 text-primary font-bold animate-pulse">
                    <i class="ph ph-clock"></i>
                    <span class="text-xs uppercase">Aguardando pagamento...</span>
                </div>
            </div>
        `,
        showConfirmButton: false,
        allowOutsideClick: false
    });

    // 🔄 Verificação automática do pagamento
    const interval = setInterval(() => {
        const checkData = new FormData();
        checkData.append('action', 'verificar_status');
        checkData.append('pedido_id', pedidoId);

        fetch('carrinho.php?id=' + idParceiro, {
            method: 'POST',
            body: checkData
        })
        .then(r => r.json())
        .then(data => {
            if (data.status === 'pago') {
                clearInterval(interval);
                window.pixInterval = null;

                localStorage.removeItem('carrinho_' + idParceiro);
                if (window.atualizarMenuGlobal) window.atualizarMenuGlobal();

                Swal.close();

                setTimeout(() => {
                    Swal.fire({
                        title: 'PAGAMENTO CONFIRMADO!',
                        html: `
                            <div class="py-4 text-center">
                                <i class="ph-fill ph-check-circle text-6xl text-green-500 mb-4"></i>
                                <p class="text-slate-600 mb-6">
                                    Seu pedido foi processado com sucesso!
                                </p>
                                <div class="grid grid-cols-1 gap-3">
                                    <a href="downloads.php?id=${idParceiro}"
                                       class="btn-primary py-3 rounded-xl font-bold text-xs uppercase">
                                        Ver Meus Downloads
                                    </a>
                                    <a href="index.php?id=${idParceiro}"
                                       class="bg-slate-100 text-slate-600 py-3 rounded-xl font-bold text-xs uppercase">
                                        Voltar para a Loja
                                    </a>
                                </div>
                            </div>
                        `,
                        showConfirmButton: false,
                        allowOutsideClick: false
                    });
                }, 400);
            }
        });
    }, 3000);

    window.pixInterval = interval;
}

// ❌ Cancelar pedido
function cancelarPedido(pedidoId) {
    const formData = new FormData();
    formData.append('action', 'cancelar_pedido');
    formData.append('pedido_id', pedidoId);

    fetch('carrinho.php?id=' + idParceiro, {
        method: 'POST',
        body: formData
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            if (window.pixInterval) {
                clearInterval(window.pixInterval);
                window.pixInterval = null;
            }
            Swal.fire('Cancelado', 'Pedido cancelado com sucesso.', 'info');
        }
    });
}

// 📋 Copiar código Pix
window.copyPix = () => {
    const text = document.getElementById('pixCode').innerText;
    const el = document.createElement('textarea');
    el.value = text;
    document.body.appendChild(el);
    el.select();
    document.execCommand('copy');
    document.body.removeChild(el);

    Swal.showValidationMessage('Código copiado!');
    setTimeout(() => Swal.resetValidationMessage(), 2000);
};

renderCart();
checkLogin();
</script>
</body>
</html>
