<?php
// Inicia sessão
session_start();

// Redireciona para login se não estiver logado
if(!isset($_SESSION['usuario'])){
    header("Location: admin_login.php");
    exit;
}

include('includes/header.php');

// ID do parceiro logado
$parceiro_logado = $_SESSION['usuario']['id'];

// Lê JSON de produtos
$produtosJson = __DIR__ . '/data/produtos.json';
if(!file_exists($produtosJson)){
    $produtosData = [];
} else {
    $produtosData = json_decode(file_get_contents($produtosJson), true) ?? [];
}

// Filtra produtos do parceiro logado
$produtos = array_filter($produtosData, fn($p)=>$p['id_parceiro']==$parceiro_logado);

// Link da loja automático
$host = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://".$_SERVER['HTTP_HOST'];
$lojaLink = $host."/loja.php?id=".$parceiro_logado;
?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<main class="pt-24 px-4 sm:px-6 lg:px-8 max-w-7xl mx-auto">

    <!-- Top bar: link loja + adicionar produto -->
    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:gap-2">
        <input type="text" id="linkLoja" value="<?= $lojaLink ?>" readonly
            class="flex-1 bg-[var(--body-bg)] dark:bg-[var(--body-bg)] text-[var(--text-primary)] rounded px-4 py-2 border border-[var(--border-color)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" />
        <button onclick="copiarLink()"
            class="mt-2 sm:mt-0 bg-[var(--accent)] text-white px-6 py-2 rounded shadow hover:bg-[var(--accent)]/90 flex items-center gap-2">
            <i class="fa-solid fa-copy"></i> Copiar
        </button>
        <a href="adicionar_produto.php"
            class="mt-2 sm:mt-0 bg-[var(--accent)] text-white px-6 py-2 rounded shadow hover:bg-[var(--accent)]/90 flex items-center gap-2">
            <i class="fa-solid fa-plus"></i> Adicionar Produto
        </a>
    </div>

    <!-- Busca -->
    <div class="mb-6">
        <input type="text" id="buscaProduto" placeholder="Buscar produto..."
            class="w-full bg-[var(--body-bg)] dark:bg-[var(--body-bg)] text-[var(--text-primary)] rounded px-4 py-2 border border-[var(--border-color)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" />
    </div>

    <!-- Grid de produtos -->
    <?php if(empty($produtos)): ?>
        <p class="text-center text-gray-500">Nenhum produto encontrado.</p>
    <?php else: ?>
    <div id="listaProdutos" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <?php foreach($produtos as $produto): ?>
        <div class="bg-[var(--menu-secondary)] dark:bg-[var(--menu-secondary)] shadow rounded p-4 flex flex-col border border-[var(--border-color)]">
            <img src="<?= htmlspecialchars($produto['imagem'] ?? 'imagem/default.png') ?>" alt="<?= htmlspecialchars($produto['nome']) ?>" class="mb-3 rounded">
            <h3 class="text-lg font-semibold text-[var(--text-primary)]"><?= htmlspecialchars($produto['nome']) ?></h3>
            <p class="text-sm text-[var(--text-secondary)] mb-1"><?= htmlspecialchars($produto['descricao']) ?></p>
            <p class="text-sm text-[var(--text-secondary)] mb-1">Categoria: <?= htmlspecialchars($produto['categoria']) ?></p>
            <p class="text-sm text-[var(--text-secondary)] mb-1">Valor: R$ <?= number_format($produto['valor'],2,",",".") ?></p>
            <p class="text-sm mb-2 <?= $produto['status']=='ativo'?'text-green-600':'text-yellow-600' ?>">Status: <?= strtoupper($produto['status']) ?></p>

            <!-- Botões -->
            <div class="mt-auto flex gap-2">
                <a href="editar_produto.php?id=<?= $produto['id'] ?>"
                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-center flex items-center justify-center gap-2">
                    <i class="fa-solid fa-pen"></i> Editar
                </a>
                <button onclick="excluirProduto('<?= $produto['id'] ?>')"
                    class="flex-1 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded flex items-center justify-center gap-2">
                    <i class="fa-solid fa-trash"></i> Excluir
                </button>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</main>

<script>
function copiarLink() {
    const input = document.getElementById('linkLoja');
    input.select();
    input.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(input.value).then(() => {
        Swal.fire({icon:'success', title:'Link copiado!', toast:true, position:'top-end', timer:2000, showConfirmButton:false});
    });
}

function excluirProduto(id){
    Swal.fire({
        title: 'Tem certeza?',
        text: "O produto será excluído!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sim, excluir!'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire('Excluído!', 'O produto foi removido.', 'success').then(()=>location.reload());
        }
    });
}

// Busca de produtos
document.getElementById('buscaProduto').addEventListener('input', function(){
    const filtro = this.value.toLowerCase();
    document.querySelectorAll('#listaProdutos > div').forEach(card=>{
        const nome = card.querySelector('h3').innerText.toLowerCase();
        const desc = card.querySelector('p').innerText.toLowerCase();
        card.style.display = (nome.includes(filtro) || desc.includes(filtro)) ? 'flex' : 'none';
    });
});
</script>